/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.apex;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.modules.salesforce.apex.rest.ApexClassInnerType;
import org.mule.modules.salesforce.apex.rest.ApexClassType;
import org.mule.modules.salesforce.apex.rest.ApexRequestHeaders;
import org.mule.modules.salesforce.apex.rest.ApexRestInvocation;
import org.mule.modules.salesforce.exception.SalesforceTransformationException;
import org.mule.modules.wsdl.WSDLInvocation;

public class ApexClient {
    private String sessionId;
    private String basePath;
    private final String proxyHost;
    private final Integer proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private final Integer connectionTimeout;
    private final Integer readTimeout;

    public ApexClient(@Nullable String proxyHost, @Nullable Integer proxyPort, @Nullable String proxyUsername, @Nullable String proxyPassword, @Nullable Integer connectionTimeout, @Nullable Integer readTimeout, @NotNull String basePath) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.basePath = basePath;
    }

    private void processInput(@NotNull Map<String, Object> input, @NotNull Map<String, String> inputParameters) {
        for (String key : inputParameters.keySet()) {
            List mapsList;
            String type = inputParameters.get(key);
            ApexClassInnerType parse = ApexClassInnerType.parse(type);
            if (!parse.isMap() || (mapsList = (List)input.get(key)) == null) continue;
            HashMap elements = new HashMap();
            for (Map element : mapsList) {
                String elementKey = (String)element.get("key");
                Object elementValue = element.get("value");
                if (elementKey == null) continue;
                elements.put(elementKey, elementValue);
            }
            if (elements.isEmpty()) continue;
            input.put(key, elements);
        }
    }

    @NotNull
    public XMLStreamReader invokeSoapMethod(@NotNull String type, @Nullable XMLStreamReader input) throws Exception {
        String wsdlName = type.split("#")[0];
        String headerPrefix = "soap";
        String namespace = "http://soap.sforce.com/schemas/class/" + wsdlName + "/";
        String serviceName = wsdlName + "_Service";
        String portName = wsdlName + "_Port";
        WSDLInvocation invocation = new WSDLInvocation();
        invocation.setBasePath(this.getSoapBasePath());
        invocation.setHeaderQNamePrefix("soap");
        invocation.setPortName(portName);
        invocation.setServiceName(serviceName);
        invocation.setWsdlNamespace(namespace);
        invocation.setSessionId(this.getSessionId());
        invocation.setProxyHost(this.proxyHost);
        invocation.setProxyPort(this.proxyPort);
        invocation.setProxyUsername(this.proxyUsername);
        invocation.setProxyPassword(this.proxyPassword);
        invocation.setConnectionTimeout(this.connectionTimeout);
        invocation.setReadTimeout(this.readTimeout);
        XMLStreamReader processedInput = this.processApexSoapInput(type, input, invocation);
        return invocation.invoke(type, processedInput);
    }

    private XMLStreamReader processApexSoapInput(@NotNull String type, @Nullable XMLStreamReader input, @NotNull WSDLInvocation invocation) throws Exception {
        if (input == null) {
            throw new Exception("The null input is not for operation " + type);
        }
        String[] wsdlAndOperation = type.split("#");
        if (wsdlAndOperation.length < 2) {
            throw new SalesforceTransformationException("The type does not have the correct format ClassName#MethodName: " + type);
        }
        String operationName = wsdlAndOperation[1];
        String stringXml = invocation.getOuterXml(input);
        if (!stringXml.trim().contains(operationName) && !stringXml.trim().equals("<NullPayload/>")) {
            throw new SalesforceTransformationException("Illegal input for operation " + type + ": " + stringXml);
        }
        return invocation.createNewXMLStreamReader(stringXml);
    }

    @NotNull
    public Map<String, Object> invokeRestMethod(@NotNull String methodName, @NotNull ApexClassType apexClass, @NotNull Map<String, Object> input, @NotNull ApexRequestHeaders requestHeadersReference, @NotNull Map<String, String> queryParameters) throws IOException {
        String resourceUrl = apexClass.getResourceUrl();
        String requestType = apexClass.getMethodRequestTypes().get(methodName);
        String outputType = apexClass.getMethodOutputType().get(methodName);
        ApexClassInnerType dataType = ApexClassInnerType.parse(outputType);
        Map<String, Map<String, String>> methodInputTypes = apexClass.getMethodInputTypes();
        this.processInput(input, methodInputTypes.get(methodName));
        ApexRestInvocation result = new ApexRestInvocation();
        result.setSessionId(this.getSessionId());
        if (resourceUrl == null) {
            throw new IOException("ApexClient is not able to set the RestResourceUrl as it was unable to read it!");
        }
        result.setServiceRelativePath(resourceUrl);
        result.setBasePath(this.getRestBasePath());
        result.setQueryParameters(queryParameters);
        result.setInputData(input);
        result.setRequestType(requestType);
        result.setMethodName(methodName);
        result.setOutputType(dataType);
        result.setRequestHeaders(requestHeadersReference);
        result.setProxyHost(this.proxyHost);
        result.setProxyPort(this.proxyPort);
        result.setProxyUsername(this.proxyUsername);
        result.setProxyPassword(this.proxyPassword);
        result.setConnectionTimeout(this.connectionTimeout);
        result.setReadTimeout(this.readTimeout);
        return result.invokeApexRest();
    }

    public String getSoapBasePath() {
        return "https://" + this.basePath + "/services/Soap/class/";
    }

    public String getRestBasePath() {
        return "https://" + this.basePath + "/services/apexrest/";
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

