/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.adapters;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.common.security.oauth.AuthorizationParameter;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.common.security.oauth.exception.UnableToAcquireAccessTokenException;
import org.mule.modules.salesforce.SalesforceOAuthDisplay;
import org.mule.modules.salesforce.SalesforceOAuthImmediate;
import org.mule.modules.salesforce.SalesforceOAuthPrompt;
import org.mule.modules.salesforce.adapters.SalesforceConnectorCapabilitiesAdapter;
import org.mule.modules.salesforce.adapters.SalesforceConnectorProcessAdapter;
import org.mule.modules.salesforce.config.SalesforceOAuth2Config;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.OnNoTokenPolicy;

public class SalesforceConnectorOAuth2Adapter
extends SalesforceConnectorProcessAdapter
implements OAuth2Adapter {
    private OAuth2Manager<OAuth2Adapter> oauthManager;
    private static final Pattern ACCESS_CODE_PATTERN = Pattern.compile("\"access_token\"\\s*:\\s*\"([^&]+?)\"");
    private static final Pattern REFRESH_TOKEN_PATTERN = Pattern.compile("\"refresh_token\"\\s*:\\s*\"([^&]+?)\"");
    private static final Pattern EXPIRATION_TIME_PATTERN = Pattern.compile("\"expires_in\"\\s*:\\s*([^&]+?),");
    private String name;
    private OnNoTokenPolicy onNoTokenPolicy;
    private String oauthVerifier;
    private String refreshToken;
    public String redirectUri;
    private String authorizationUrl = null;
    private String accessTokenUrl = null;
    private Date expiration;
    private static final Logger LOGGER = Logger.getLogger(SalesforceConnectorOAuth2Adapter.class);

    public SalesforceConnectorOAuth2Adapter(OAuth2Manager<OAuth2Adapter> oauthManager) {
        this.oauthManager = oauthManager;
        this.setConfig(new SalesforceOAuth2Config());
    }

    public Pattern getAccessCodePattern() {
        return ACCESS_CODE_PATTERN;
    }

    public Pattern getRefreshTokenPattern() {
        return REFRESH_TOKEN_PATTERN;
    }

    public Pattern getExpirationTimePattern() {
        return EXPIRATION_TIME_PATTERN;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public OnNoTokenPolicy getOnNoTokenPolicy() {
        return this.onNoTokenPolicy;
    }

    public void setOnNoTokenPolicy(OnNoTokenPolicy value) {
        this.onNoTokenPolicy = value;
    }

    public String getOauthVerifier() {
        return this.oauthVerifier;
    }

    public void setOauthVerifier(String value) {
        this.oauthVerifier = value;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String value) {
        this.refreshToken = value;
    }

    public void setAuthorizationUrl(String value) {
        this.authorizationUrl = value;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAccessTokenUrl(String value) {
        this.accessTokenUrl = value;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setExpiration(Date value) {
        this.expiration = value;
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
    }

    public String authorize(Map<String, String> extraParameters, String authorizationUrl, String redirectUri) {
        return this.oauthManager.buildAuthorizeUrl(extraParameters, authorizationUrl, redirectUri);
    }

    public void fetchAccessToken(String redirectUri) throws UnableToAcquireAccessTokenException {
        this.oauthManager.fetchAccessToken((OAuth2Adapter)this, redirectUri);
    }

    public void refreshAccessToken(String accessTokenId) throws UnableToAcquireAccessTokenException {
        this.oauthManager.refreshAccessToken((OAuth2Adapter)this, accessTokenId);
    }

    public boolean hasTokenExpired() {
        return this.expiration != null && this.expiration.before(new Date());
    }

    public void reset() {
        this.expiration = null;
        this.oauthVerifier = null;
        this.setAccessToken(null);
    }

    public void hasBeenAuthorized() throws NotAuthorizedException {
        if (this.getAccessToken() == null) {
            throw new NotAuthorizedException("This connector has not yet been authorized, please authorize by calling \"authorize\".");
        }
    }

    public Set<AuthorizationParameter<?>> getAuthorizationParameters() {
        AuthorizationParameter display = new AuthorizationParameter("display", "Tailors the login page to the user's device type.", false, (Object)"", SalesforceOAuthDisplay.class);
        AuthorizationParameter immediate = new AuthorizationParameter("immediate", "Avoid interacting with the user.", true, (Object)"FALSE", SalesforceOAuthImmediate.class);
        AuthorizationParameter prompt = new AuthorizationParameter("prompt", "Specifies how the authorization server prompts the user for reauthentication and reapproval.", true, (Object)"", SalesforceOAuthPrompt.class);
        HashSet result = new HashSet();
        result.add(display);
        result.add(immediate);
        result.add(prompt);
        return result;
    }

    public String getConsumerKey() {
        return ((SalesforceOAuth2Config)super.getConfig()).getConsumerKey();
    }

    public void setConsumerKey(String value) {
        ((SalesforceOAuth2Config)super.getConfig()).setConsumerKey(value);
    }

    public String getConsumerSecret() {
        return ((SalesforceOAuth2Config)super.getConfig()).getConsumerSecret();
    }

    public void setConsumerSecret(String value) {
        ((SalesforceOAuth2Config)super.getConfig()).setConsumerSecret(value);
    }

    public String getAccessToken() {
        return ((SalesforceOAuth2Config)super.getConfig()).getAccessToken();
    }

    public void setAccessToken(String value) {
        ((SalesforceOAuth2Config)super.getConfig()).setAccessToken(value);
    }

    public String getScope() {
        return "";
    }

    public void postAuth() throws Exception {
        ((SalesforceOAuth2Config)super.getConfig()).postAuthorize();
    }

    @Override
    public <P> ProcessTemplate<P, SalesforceConnectorCapabilitiesAdapter> getProcessTemplate() {
        throw new RuntimeException();
    }

    public String getAccessTokenRegex() {
        return ACCESS_CODE_PATTERN.pattern();
    }

    public String getExpirationRegex() {
        return EXPIRATION_TIME_PATTERN.pattern();
    }

    public String getRefreshTokenRegex() {
        return REFRESH_TOKEN_PATTERN.pattern();
    }

    public String getVerifierRegex() {
        return this.oauthVerifier;
    }
}

