/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.google.common.base.Charsets;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.common.bulk.BulkItem;
import org.mule.common.bulk.BulkOperationResult;
import org.mule.config.i18n.MessageFactory;
import org.mule.modules.salesforce.bulk.EnrichedSaveResult;
import org.mule.modules.salesforce.bulk.EnrichedUpsertResult;
import org.mule.modules.salesforce.exception.SalesforceBulkException;
import org.mule.transformer.types.DataTypeFactory;

public class SalesforceUtils {
    private static final Logger logger = Logger.getLogger(SalesforceUtils.class);
    public static final DataType<BulkOperationResult> BULK_OPERATION_RESULT_DATA_TYPE = DataTypeFactory.create(BulkOperationResult.class);
    public static final DataType<XMLStreamReader> INVOKE_SOAP_APEX_DATA_TYPE = DataTypeFactory.create(XMLStreamReader.class);
    public static final DataType<Map> INVOKE_REST_APEX_DATA_TYPE = DataTypeFactory.create(Map.class);
    public static final String NullPayloadXMLTag = "<NullPayload/>";
    private static final String FIELDS_TO_NULL_ATTR = "fieldsToNull";
    public static final String UTF_8_ENCODING_NAME = "UTF-8";
    private static XMLStreamReader nullPayloadXMLValue;

    private SalesforceUtils() {
    }

    @NotNull
    public static Map<String, Object> toMap(@Nullable XmlObject xmlObject) {
        Object value;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (xmlObject != null && (value = xmlObject.getValue()) == null && xmlObject.hasChildren()) {
            Iterator childrenIterator = xmlObject.getChildren();
            while (childrenIterator.hasNext()) {
                XmlObject child = (XmlObject)childrenIterator.next();
                if (child.getValue() != null) {
                    result.put(child.getName().getLocalPart(), child.getValue());
                    continue;
                }
                if (child.getChildren().hasNext()) {
                    SalesforceUtils.putToMultiMap(result, child.getName().getLocalPart(), SalesforceUtils.toMap(child));
                    continue;
                }
                result.put(child.getName().getLocalPart(), null);
            }
        }
        return result;
    }

    @NotNull
    public static com.sforce.async.SObject toAsyncSObject(Map<String, Object> map, Integer batchSobjectMaxDepth) {
        com.sforce.async.SObject sObject = batchSobjectMaxDepth != null && batchSobjectMaxDepth != 0 ? new com.sforce.async.SObject(batchSobjectMaxDepth.intValue()) : new com.sforce.async.SObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (value != null) {
                if (value instanceof Map) {
                    sObject.setFieldReference(key, SalesforceUtils.toAsyncSObject(SalesforceUtils.toSObjectMap((Map)value), batchSobjectMaxDepth));
                    continue;
                }
                if (SalesforceUtils.isDateField(value)) {
                    sObject.setField(key, SalesforceUtils.convertDateToString(value));
                    continue;
                }
                sObject.setField(key, value.toString());
                continue;
            }
            sObject.setField(key, null);
        }
        return sObject;
    }

    public static SObject toSObject(String type, Map<String, Object> map) {
        SObject sObject = new SObject();
        sObject.setType(type);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.equals(FIELDS_TO_NULL_ATTR)) {
                sObject.setFieldsToNull((String[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                Map value = (Map)entry.getValue();
                sObject.setField(key, (Object)SalesforceUtils.toSObject(key, SalesforceUtils.toSObjectMap(value)));
                continue;
            }
            sObject.setField(key, entry.getValue());
        }
        return sObject;
    }

    public static Map<String, Object> toSObjectMap(Map<Object, Object> map) {
        HashMap<String, Object> sObjectMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            sObjectMap.put(entry.getKey().toString(), entry.getValue());
        }
        return sObjectMap;
    }

    public static com.sforce.async.SObject[] toAsyncSObjectList(List<Map<String, Object>> objects, Integer batchSobjectMaxDepth) {
        com.sforce.async.SObject[] sobjects = new com.sforce.async.SObject[objects.size()];
        int s = 0;
        for (Map<String, Object> map : objects) {
            sobjects[s] = SalesforceUtils.toAsyncSObject(map, batchSobjectMaxDepth);
            ++s;
        }
        return sobjects;
    }

    public static SObject[] toSObjectList(String type, List<Map<String, Object>> objects) {
        SObject[] sobjects = new SObject[objects.size()];
        int s = 0;
        for (Map<String, Object> map : objects) {
            sobjects[s] = SalesforceUtils.toSObject(type, map);
            ++s;
        }
        return sobjects;
    }

    private static void putToMultiMap(Map<String, Object> map, String key, Object newValue) {
        if (map.containsKey(key)) {
            Object value = map.get(key);
            if (value instanceof List) {
                ((List)value).add(newValue);
            } else {
                map.put(key, new ArrayList<Object>(Arrays.asList(value, newValue)));
            }
        } else {
            map.put(key, newValue);
        }
    }

    protected static boolean isDateField(Object object) {
        return object instanceof Date || object instanceof GregorianCalendar || object instanceof Calendar;
    }

    protected static String convertDateToString(Object object) {
        return new DateTime(object).toString();
    }

    @NotNull
    public static BulkOperationResult<SObject> saveResultToBulkOperationResult(Collection<SaveResult> results) {
        BulkOperationResult.BulkOperationResultBuilder builder = BulkOperationResult.builder();
        for (SaveResult sr : results) {
            BulkItem.BulkItemBuilder itemBuilder = BulkItem.builder();
            if (sr instanceof EnrichedSaveResult) {
                itemBuilder.setPayload((Object)((EnrichedSaveResult)sr).getPayload());
            }
            if (!sr.isSuccess()) {
                itemBuilder.setException((Exception)new SalesforceBulkException(sr.getErrors()));
            }
            builder.addItem(itemBuilder);
        }
        return builder.build();
    }

    public static BulkOperationResult<SObject> upsertResultToBulkOperationResult(Collection<UpsertResult> results) {
        BulkOperationResult.BulkOperationResultBuilder builder = BulkOperationResult.builder();
        for (UpsertResult ur : results) {
            BulkItem.BulkItemBuilder itemBuilder = BulkItem.builder();
            if (ur instanceof EnrichedUpsertResult) {
                itemBuilder.setPayload((Object)((EnrichedUpsertResult)ur).getPayload());
            }
            if (ur.isSuccess()) {
                itemBuilder.setMessage(ur.isCreated() ? "Created" : "Updated");
            } else {
                itemBuilder.setException((Exception)new SalesforceBulkException(ur.getErrors()));
            }
            builder.addItem(itemBuilder);
        }
        return builder.build();
    }

    public static EnrichedSaveResult enrich(SaveResult saveResut) {
        return new EnrichedSaveResult(saveResut);
    }

    public static EnrichedUpsertResult enrich(UpsertResult upsertResult) {
        return new EnrichedUpsertResult(upsertResult);
    }

    public static EnrichedSaveResult enrichWithPayload(SaveResult saveResult, SObject payload) {
        EnrichedSaveResult enriched = SalesforceUtils.enrich(saveResult);
        enriched.setPayload(payload);
        return enriched;
    }

    public static EnrichedUpsertResult enrichWithPayload(UpsertResult upsertResult, SObject payload) {
        EnrichedUpsertResult enriched = SalesforceUtils.enrich(upsertResult);
        enriched.setPayload(payload);
        return enriched;
    }

    public static List<SaveResult> enrichWithPayload(SObject[] objects, SaveResult[] results) {
        SalesforceUtils.assertResultLength(objects, results);
        ArrayList<SaveResult> enriched = new ArrayList<SaveResult>(results.length);
        for (int i = 0; i < results.length; ++i) {
            enriched.add(SalesforceUtils.enrichWithPayload(results[i], objects[i]));
        }
        return enriched;
    }

    public static List<UpsertResult> enrichWithPayload(SObject[] objects, UpsertResult[] results) {
        SalesforceUtils.assertResultLength(objects, results);
        ArrayList<UpsertResult> enriched = new ArrayList<UpsertResult>(results.length);
        for (int i = 0; i < results.length; ++i) {
            enriched.add(SalesforceUtils.enrichWithPayload(results[i], objects[i]));
        }
        return enriched;
    }

    private static void assertResultLength(SObject[] list, Object[] results) {
        if (list.length != results.length) {
            throw new IllegalStateException(String.format("Protocol exception: Objects and results lists should have the same lenghts. %d and %d found instead", list.length, results.length));
        }
    }

    public static URI createTempDir(String dirName) throws IOException {
        String osTempDir = System.getProperty("java.io.tmpdir");
        String tempDir = osTempDir.endsWith("/") || osTempDir.endsWith("\\") ? osTempDir + dirName : osTempDir + File.separator + dirName;
        File tempDirFile = new File(tempDir);
        if (!tempDirFile.exists() && !tempDirFile.mkdirs()) {
            throw new IOException("Unable to create temporary directory");
        }
        return tempDirFile.toURI();
    }

    @NotNull
    public static synchronized XMLStreamReader getNullXmlStreamReaderMarker() throws TransformerException {
        XMLStreamReader result = nullPayloadXMLValue;
        if (nullPayloadXMLValue == null) {
            String nullPayloadXMLTag = NullPayloadXMLTag;
            ByteArrayInputStream is = new ByteArrayInputStream(nullPayloadXMLTag.getBytes(Charsets.UTF_8));
            try {
                nullPayloadXMLValue = XMLInputFactory.newInstance().createXMLStreamReader(new InputStreamReader((InputStream)is, Charsets.UTF_8));
            }
            catch (XMLStreamException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new TransformerException(MessageFactory.createStaticMessage((String)"Unable to transform NullPayload to XmlStreamReader"));
            }
            result = nullPayloadXMLValue;
        }
        return result;
    }

    @NotNull
    public static XMLStreamReader createNewXMLStreamReader(byte[] data) throws XMLStreamException, UnsupportedEncodingException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        InputStreamReader myReader = new InputStreamReader((InputStream)is, Charsets.UTF_8);
        XMLStreamReader reader = factory.createXMLStreamReader(myReader);
        return reader;
    }
}

