/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.google.common.base.Charsets;
import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchRequest;
import com.sforce.async.BatchResult;
import com.sforce.async.BulkConnection;
import com.sforce.async.ConcurrencyMode;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.OperationEnum;
import com.sforce.async.QueryResultList;
import com.sforce.soap.metadata.DeleteResult;
import com.sforce.soap.metadata.DescribeMetadataResult;
import com.sforce.soap.metadata.FileProperties;
import com.sforce.soap.metadata.ListMetadataQuery;
import com.sforce.soap.metadata.Metadata;
import com.sforce.soap.metadata.ReadResult;
import com.sforce.soap.metadata.SaveResult;
import com.sforce.soap.metadata.UpsertResult;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.EmptyRecycleBinResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.GetDeletedResult;
import com.sforce.soap.partner.GetUpdatedResult;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.LeadConvert;
import com.sforce.soap.partner.LeadConvertResult;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SearchRecord;
import com.sforce.soap.partner.SearchResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.bind.XmlObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.annotations.lifecycle.OnException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.callback.StopSourceCallback;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.QueryVisitor;
import org.mule.modules.salesforce.Config;
import org.mule.modules.salesforce.ExceptionDecorator;
import org.mule.modules.salesforce.MetadataOperationType;
import org.mule.modules.salesforce.MetadataServiceUtil;
import org.mule.modules.salesforce.MetadataType;
import org.mule.modules.salesforce.ObjectStoreHelper;
import org.mule.modules.salesforce.SalesforcePagingDelegate;
import org.mule.modules.salesforce.SalesforceUtils;
import org.mule.modules.salesforce.SfdcQueryVisitor;
import org.mule.modules.salesforce.apex.ApexClient;
import org.mule.modules.salesforce.apex.rest.ApexClassType;
import org.mule.modules.salesforce.apex.rest.ApexRequestHeaders;
import org.mule.modules.salesforce.apex.rest.ApexTypeUtils;
import org.mule.modules.salesforce.api.SalesforceHeader;
import org.mule.modules.salesforce.api.SalesforceSoapAdapter;
import org.mule.modules.salesforce.bulk.SaveResultToBulkOperationTransformer;
import org.mule.modules.salesforce.bulk.UpsertResultToBulkOperationTransformer;
import org.mule.modules.salesforce.config.CustomPartnerConnection;
import org.mule.modules.salesforce.config.Subscription;
import org.mule.modules.salesforce.exception.SalesforceException;
import org.mule.modules.salesforce.exception.SalesforceTransformationException;
import org.mule.modules.salesforce.lazystream.impl.LazyQueryResultInputStream;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.ProviderAwarePagingDelegate;
import org.mule.transformer.AbstractDiscoverableTransformer;
import org.mule.transport.NullPayload;
import org.mule.util.BeanUtils;
import org.springframework.util.StringUtils;

@OnException(handler=ExceptionDecorator.class)
public class SalesforceConnector {
    private static final Logger logger = Logger.getLogger(SalesforceConnector.class);
    @Inject
    private MuleContext muleContext;
    private Config config;
    private ObjectStore<? extends Serializable> timeObjectStore;
    private Integer batchSobjectMaxDepth;

    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public void setConfig(@NotNull Config config) {
        this.config = config;
    }

    public List<com.sforce.soap.partner.SaveResult> create(String type, List<Map<String, Object>> objects, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        SObject[] sObjects = SalesforceUtils.toSObjectList(type, objects);
        return SalesforceUtils.enrichWithPayload(sObjects, this.buildPartnerConnection(headers).create(sObjects));
    }

    public JobInfo createJob(OperationEnum operation, String type, String externalIdFieldName, ContentType contentType, ConcurrencyMode concurrencyMode) throws AsyncApiException, SalesforceException {
        return this.createJobInfo(operation, type, externalIdFieldName, contentType, concurrencyMode);
    }

    public JobInfo closeJob(String jobId) throws AsyncApiException, SalesforceException {
        return this.config.getBulkConnection().closeJob(jobId);
    }

    public JobInfo abortJob(String jobId) throws AsyncApiException, SalesforceException {
        return this.config.getBulkConnection().abortJob(jobId);
    }

    public JobInfo jobInfo(String jobId) throws AsyncApiException, SalesforceException {
        return this.config.getBulkConnection().getJobStatus(jobId);
    }

    public BatchInfo createBatch(JobInfo jobInfo, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(jobInfo, objects);
    }

    public BatchInfo createBatchStream(JobInfo jobInfo, InputStream stream) throws AsyncApiException, SalesforceException {
        BulkConnection bulkConnection = this.config.getBulkConnection();
        BatchInfo result = ContentType.ZIP_XML.equals((Object)jobInfo.getContentType()) || ContentType.ZIP_CSV.equals((Object)jobInfo.getContentType()) ? bulkConnection.createBatchFromZipStream(jobInfo, stream) : bulkConnection.createBatchFromStream(jobInfo, stream);
        return result;
    }

    public BatchInfo createBatchForQuery(JobInfo jobInfo, String query) throws AsyncApiException, SalesforceException {
        byte[] bytes = query.getBytes(Charsets.UTF_8);
        ByteArrayInputStream queryStream = new ByteArrayInputStream(bytes);
        return this.createBatchForQuery(jobInfo, queryStream);
    }

    public BatchInfo createBulk(String type, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(this.createJobInfo(OperationEnum.insert, type), objects);
    }

    @Nullable
    public com.sforce.soap.partner.SaveResult createSingle(String type, Map<String, Object> object, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        CustomPartnerConnection customPartnerConnection = this.buildPartnerConnection(headers);
        SObject[] sObjects = new SObject[]{SalesforceUtils.toSObject(type, object)};
        com.sforce.soap.partner.SaveResult[] saveResults = customPartnerConnection.create(sObjects);
        return saveResults.length > 0 ? saveResults[0] : null;
    }

    public List<com.sforce.soap.partner.SaveResult> update(String type, List<Map<String, Object>> objects, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        SObject[] sObjects = SalesforceUtils.toSObjectList(type, objects);
        return SalesforceUtils.enrichWithPayload(sObjects, this.buildPartnerConnection(headers).update(sObjects));
    }

    public com.sforce.soap.partner.SaveResult updateSingle(String type, Map<String, Object> object, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        CustomPartnerConnection customPartnerConnection = this.buildPartnerConnection(headers);
        SObject[] sObjects = new SObject[]{SalesforceUtils.toSObject(type, object)};
        return customPartnerConnection.update(sObjects)[0];
    }

    public BatchInfo updateBulk(String type, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(this.createJobInfo(OperationEnum.update, type), objects);
    }

    public List<com.sforce.soap.partner.UpsertResult> upsert(String externalIdFieldName, String type, List<Map<String, Object>> objects, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        SObject[] sObjects = SalesforceUtils.toSObjectList(type, objects);
        return SalesforceUtils.enrichWithPayload(sObjects, this.buildPartnerConnection(headers).upsert(externalIdFieldName, sObjects));
    }

    public BatchInfo upsertBulk(String type, String externalIdFieldName, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(this.createJobInfo(OperationEnum.upsert, type, externalIdFieldName, null, null), objects);
    }

    public BatchInfo batchInfo(BatchInfo batchInfo) throws AsyncApiException, SalesforceException {
        return this.config.getBulkConnection().getBatchInfo(batchInfo.getJobId(), batchInfo.getId());
    }

    public BatchResult batchResult(BatchInfo batchInfo) throws AsyncApiException, SalesforceException {
        return this.config.getBulkConnection().getBatchResult(batchInfo.getJobId(), batchInfo.getId());
    }

    public InputStream batchResultStream(BatchInfo batchInfo) throws AsyncApiException, SalesforceException {
        return this.config.getBulkConnection().getBatchResultStream(batchInfo.getJobId(), batchInfo.getId());
    }

    public InputStream queryResultStream(BatchInfo batchInfo) throws AsyncApiException, SalesforceException {
        QueryResultList queryResultList = this.config.getBulkConnection().getQueryResultList(batchInfo.getJobId(), batchInfo.getId());
        String[] jobResultIds = queryResultList.getResult();
        logger.debug((Object)String.format("SF queryResultStream for JobId[%s] BatchId[%s] - Pages[%s]", batchInfo.getJobId(), batchInfo.getId(), jobResultIds.length));
        if (jobResultIds.length > 0) {
            LinkedList<LazyQueryResultInputStream> inputStreams = new LinkedList<LazyQueryResultInputStream>();
            for (String jobResultId : jobResultIds) {
                inputStreams.add(new LazyQueryResultInputStream(this.config.getBulkConnection(), batchInfo.getJobId(), batchInfo.getId(), jobResultId));
            }
            return new SequenceInputStream(Collections.enumeration(inputStreams));
        }
        return null;
    }

    public DescribeGlobalResult describeGlobal() throws ConnectionException {
        return this.buildPartnerConnection().describeGlobal();
    }

    public List<Map<String, Object>> retrieve(String type, List<String> ids, List<String> fields, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        String fiedsCommaDelimited = StringUtils.collectionToCommaDelimitedString(fields);
        SObject[] sObjects = this.buildPartnerConnection(headers).retrieve(fiedsCommaDelimited, type, ids.toArray(new String[ids.size()]));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (sObjects != null) {
            for (SObject sObject : sObjects) {
                result.add(SalesforceUtils.toMap((XmlObject)sObject));
            }
        }
        return result;
    }

    public ProviderAwarePagingDelegate<Map<String, Object>, SalesforceConnector> query(String query, PagingConfiguration pagingConfiguration, Map<SalesforceHeader, Object> headers) {
        return new SalesforcePagingDelegate(query, headers){

            @Override
            protected QueryResult doQuery(CustomPartnerConnection connection, String query) throws ConnectionException {
                return connection.query(query);
            }
        };
    }

    public String toNativeQuery(DsqlQuery query) {
        SfdcQueryVisitor visitor = new SfdcQueryVisitor();
        query.accept((QueryVisitor)visitor);
        return visitor.dsqlQuery();
    }

    public List<Map<String, Object>> nonPaginatedQuery(String query, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        CustomPartnerConnection customPartnerConnection = this.buildPartnerConnection(headers);
        QueryResult queryResult = customPartnerConnection.query(query);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        while (queryResult != null) {
            for (SObject object : queryResult.getRecords()) {
                result.add(SalesforceUtils.toMap((XmlObject)object));
            }
            if (queryResult.isDone()) break;
            queryResult = customPartnerConnection.queryMore(queryResult.getQueryLocator());
        }
        return result;
    }

    public ProviderAwarePagingDelegate<Map<String, Object>, SalesforceConnector> queryAll(String query, PagingConfiguration pagingConfiguration, Map<SalesforceHeader, Object> headers) {
        return new SalesforcePagingDelegate(query, headers){

            @Override
            protected QueryResult doQuery(CustomPartnerConnection connection, String query) throws ConnectionException {
                return connection.queryAll(query);
            }
        };
    }

    public List<Map<String, Object>> search(String query, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        SearchResult searchResult = this.buildPartnerConnection(headers).search(query);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (SearchRecord object : searchResult.getSearchRecords()) {
            result.add(SalesforceUtils.toMap((XmlObject)object.getRecord()));
        }
        return result;
    }

    public Map<String, Object> querySingle(String query, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        SObject[] result = this.buildPartnerConnection(headers).query(query).getRecords();
        return result.length > 0 ? SalesforceUtils.toMap((XmlObject)result[0]) : null;
    }

    public LeadConvertResult convertLead(String leadId, String contactId, String accountId, Boolean overWriteLeadSource, Boolean doNotCreateOpportunity, String opportunityName, String convertedStatus, Boolean sendEmailToOwner, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        LeadConvert leadConvert = new LeadConvert();
        leadConvert.setLeadId(leadId);
        leadConvert.setContactId(contactId);
        leadConvert.setAccountId(accountId);
        leadConvert.setOverwriteLeadSource(overWriteLeadSource.booleanValue());
        leadConvert.setDoNotCreateOpportunity(doNotCreateOpportunity.booleanValue());
        if (opportunityName != null) {
            leadConvert.setOpportunityName(opportunityName);
        }
        leadConvert.setConvertedStatus(convertedStatus);
        leadConvert.setSendNotificationEmail(sendEmailToOwner.booleanValue());
        LeadConvert[] list = new LeadConvert[]{leadConvert};
        CustomPartnerConnection customPartnerConnection = this.buildPartnerConnection(headers);
        LeadConvertResult[] leadConvertResults = customPartnerConnection.convertLead(list);
        return leadConvertResults[0];
    }

    public List<EmptyRecycleBinResult> emptyRecycleBin(List<String> ids, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        CustomPartnerConnection customPartnerConnection = this.buildPartnerConnection(headers);
        String[] idsArray = ids.toArray(new String[ids.size()]);
        EmptyRecycleBinResult[] binArray = customPartnerConnection.emptyRecycleBin(idsArray);
        return Arrays.asList(binArray);
    }

    public Calendar getServerTimestamp() throws ConnectionException {
        CustomPartnerConnection partnerConnection = this.buildPartnerConnection();
        return partnerConnection.getServerTimestamp().getTimestamp();
    }

    public List<com.sforce.soap.partner.DeleteResult> delete(List<String> ids, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        CustomPartnerConnection partnerConnection = this.buildPartnerConnection(headers);
        String[] idsList = ids.toArray(new String[ids.size()]);
        com.sforce.soap.partner.DeleteResult[] delete = partnerConnection.delete(idsList);
        return Arrays.asList(delete);
    }

    public BatchInfo hardDeleteBulk(String type, List<Map<String, Object>> objects) throws Exception {
        return this.createBatchAndCompleteRequest(this.createJobInfo(OperationEnum.hardDelete, type), objects);
    }

    public GetUpdatedResult getUpdatedRange(String type, Calendar startTime, Calendar endTime, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        Calendar endTimeCopy = endTime;
        if (endTimeCopy == null) {
            Calendar serverTime = this.buildPartnerConnection().getServerTimestamp().getTimestamp();
            endTimeCopy = (Calendar)serverTime.clone();
        }
        if (endTimeCopy.getTimeInMillis() - startTime.getTimeInMillis() < 60000L) {
            endTimeCopy.add(12, 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting updated " + type + " objects between " + startTime.getTime() + " and " + endTimeCopy.getTime()));
        }
        return this.buildPartnerConnection(headers).getUpdated(type, startTime, endTimeCopy);
    }

    public GetDeletedResult getDeletedRange(String type, Calendar startTime, Calendar endTime, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        Calendar serverTime;
        Calendar endTimeCopy = endTime;
        if (endTimeCopy == null && (endTimeCopy = (Calendar)(serverTime = this.buildPartnerConnection().getServerTimestamp().getTimestamp()).clone()).getTimeInMillis() - startTime.getTimeInMillis() < 60000L) {
            endTimeCopy.add(12, 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting deleted " + type + " objects between " + startTime.getTime() + " and " + endTimeCopy.getTime()));
        }
        return this.buildPartnerConnection(headers).getDeleted(type, startTime, endTimeCopy);
    }

    public DescribeSObjectResult describeSObject(String type) throws ConnectionException {
        return this.buildPartnerConnection().describeSObject(type);
    }

    public GetDeletedResult getDeleted(String type, int duration, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        Calendar serverTime = this.buildPartnerConnection().getServerTimestamp().getTimestamp();
        Calendar startTime = (Calendar)serverTime.clone();
        Calendar endTime = (Calendar)serverTime.clone();
        startTime.add(12, -duration);
        return this.getDeletedRange(type, startTime, endTime, headers);
    }

    public GetUpdatedResult getUpdated(String type, int duration, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        Calendar serverTime = this.buildPartnerConnection().getServerTimestamp().getTimestamp();
        Calendar startTime = (Calendar)serverTime.clone();
        Calendar endTime = (Calendar)serverTime.clone();
        startTime.add(12, -duration);
        return this.getUpdatedRange(type, startTime, endTime, headers);
    }

    public List<Map<String, Object>> getUpdatedObjects(String type, int initialTimeWindow, List<String> fields, Map<SalesforceHeader, Object> headers) throws ConnectionException, ObjectStoreException {
        GetUpdatedResult getUpdatedResult;
        ObjectStore<? extends Serializable> objectStore;
        Calendar now = (Calendar)this.buildPartnerConnection().getServerTimestamp().getTimestamp().clone();
        boolean initialTimeWindowUsed = false;
        ConnectorConfig config = this.buildPartnerConnection().getConfig();
        String username = config.getUsername();
        ObjectStoreHelper<? extends Serializable> objectHelper = ObjectStoreHelper.create(username, objectStore = this.getObjectStore(username));
        Calendar startTime = objectHelper.getTimestamp(type);
        if (startTime == null) {
            startTime = (Calendar)now.clone();
            startTime.add(12, -1 * initialTimeWindow);
            initialTimeWindowUsed = true;
        }
        if ((getUpdatedResult = this.getUpdatedRange(type, startTime, now, headers)).getLatestDateCovered().equals(startTime) && !initialTimeWindowUsed && getUpdatedResult.getIds().length > 0) {
            logger.debug((Object)"Ignoring duplicated results from getUpdated() call");
            return Collections.emptyList();
        }
        List<Map<String, Object>> result = this.retrieve(type, Arrays.asList(getUpdatedResult.getIds()), fields, headers);
        objectHelper.updateTimestamp(getUpdatedResult, type);
        return result;
    }

    public void resetUpdatedObjectsTimestamp(String type) throws ObjectStoreException {
        if (this.getTimeObjectStore() == null) {
            logger.warn((Object)"Trying to reset updated objects timestamp but no object store has been set, was getUpdatedObjects ever executed?");
            return;
        }
        ConnectorConfig config = this.buildPartnerConnection().getConfig();
        String username = config.getUsername();
        ObjectStore<? extends Serializable> objectStore = this.getObjectStore(username);
        ObjectStoreHelper<? extends Serializable> objectStoreHelper = ObjectStoreHelper.create(username, objectStore);
        objectStoreHelper.resetTimestamps(type);
    }

    public void setPassword(String userId, String newPassword, Map<SalesforceHeader, Object> headers) throws ConnectionException {
        this.buildPartnerConnection(headers).setPassword(userId, newPassword);
    }

    public void publishTopic(String topicName, String query, String description) throws ConnectionException {
        QueryResult result = this.buildPartnerConnection().query("SELECT Id FROM PushTopic WHERE Name = '" + topicName + "'");
        if (result.getSize() == 0) {
            SObject pushTopic = new SObject();
            pushTopic.setType("PushTopic");
            pushTopic.setField("ApiVersion", (Object)this.config.getApiVersion());
            if (description != null) {
                pushTopic.setField("Description", (Object)description);
            }
            pushTopic.setField("Name", (Object)topicName);
            pushTopic.setField("Query", (Object)query);
            com.sforce.soap.partner.SaveResult[] saveResults = this.buildPartnerConnection().create(new SObject[]{pushTopic});
            if (!saveResults[0].isSuccess()) {
                Error error = saveResults[0].getErrors()[0];
                throw new ConnectionException(error.getMessage());
            }
        } else {
            SObject oldTopic = result.getRecords()[0];
            SObject newTopic = new SObject();
            newTopic.setType(oldTopic.getType());
            newTopic.setId(oldTopic.getId());
            if (description != null) {
                newTopic.setField("Description", (Object)description);
            }
            newTopic.setField("Query", (Object)query);
            com.sforce.soap.partner.SaveResult[] saveResults = this.buildPartnerConnection().update(new SObject[]{newTopic});
            if (!saveResults[0].isSuccess()) {
                Error error = saveResults[0].getErrors()[0];
                throw new ConnectionException(error.getMessage());
            }
        }
    }

    public GetUserInfoResult getUserInfo() throws ConnectionException {
        return this.buildPartnerConnection().getUserInfo();
    }

    public List<SaveResult> createMetadata(String type, List<Map<String, Object>> objects) throws Exception {
        return MetadataServiceUtil.callCreateUpdateService(this.config.getMetadataConnection(), type, objects, MetadataOperationType.CREATE);
    }

    public List<SaveResult> updateMetadata(String type, List<Map<String, Object>> objects) throws Exception {
        return MetadataServiceUtil.callCreateUpdateService(this.config.getMetadataConnection(), type, objects, MetadataOperationType.UPDATE);
    }

    public List<UpsertResult> upsertMetadata(String type, List<Map<String, Object>> objects) throws Exception {
        return MetadataServiceUtil.callUpsertService(this.config.getMetadataConnection(), type, objects);
    }

    public List<DeleteResult> deleteMetadata(String type, List<String> fullNames) throws Exception {
        return MetadataServiceUtil.callDeleteService(this.config.getMetadataConnection(), type, fullNames);
    }

    public SaveResult renameMetadata(String type, String oldFullName, String newFullName) throws Exception {
        return MetadataServiceUtil.callRenameService(this.config.getMetadataConnection(), type, oldFullName, newFullName);
    }

    public List<Map<String, Object>> readMetadata(String type, List<String> fullNames) throws Exception {
        Class<?> metadataObjClass;
        ReadResult readResult = MetadataServiceUtil.callReadService(this.config.getMetadataConnection(), type, fullNames);
        Metadata[] metadataObjects = readResult.getRecords();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (metadataObjects != null && metadataObjects.length > 0 && (metadataObjClass = MetadataType.valueOf(type).getMetadataEntityClass()) != null) {
            for (Metadata metadataObj : metadataObjects) {
                Map beanMap = BeanUtils.describe(metadataObjClass.cast(metadataObj));
                result.add(beanMap);
            }
        }
        return result;
    }

    public List<FileProperties> listMetadata(String type) throws ConnectionException {
        MetadataType metadataType = MetadataType.valueOf(type);
        ListMetadataQuery query = new ListMetadataQuery();
        query.setType(metadataType.getDisplayName());
        FileProperties[] fileProperties = this.config.getMetadataConnection().listMetadata(new ListMetadataQuery[]{query}, this.config.getApiVersion());
        return Arrays.asList(fileProperties);
    }

    public DescribeMetadataResult describeMetadata() throws ConnectionException {
        return this.config.getMetadataConnection().describeMetadata(this.config.getApiVersion());
    }

    public void deployMetadata(InputStream stream) throws Exception {
        MetadataServiceUtil.callDeployService(this.config.getMetadataConnection(), stream);
    }

    public InputStream retrieveMetadata(List<String> packageNames, List<String> specificFiles, InputStream unpackaged) throws Exception {
        return MetadataServiceUtil.callRetrieveService(this.config.getMetadataConnection(), packageNames, specificFiles, unpackaged);
    }

    public StopSourceCallback subscribeTopic(@NotNull String topic, SourceCallback callback) throws Exception {
        final String topicName = topic.startsWith("/") ? "/topic" + topic : "/topic/" + topic;
        boolean subscribed = false;
        if (this.config.isReadyToSubscribe()) {
            this.config.subscribe(topicName, callback);
            subscribed = true;
        }
        this.config.getSubscriptions().add(new Subscription(topicName, callback, subscribed));
        return new StopSourceCallback(){

            public void stop() throws Exception {
                SalesforceConnector.this.config.getBayeuxClient().unsubscribe(topicName);
            }
        };
    }

    public String getSessionId() {
        return this.config.getSessionId();
    }

    public String getServerUrl() throws SalesforceException {
        Map<String, String> resultUrls = this.config.getUrls();
        return resultUrls.get("partner");
    }

    public XMLStreamReader invokeApexSoapMethod(String soapMethodName, @Nullable Object input) throws Exception {
        XMLStreamReader streamReader;
        Object inputCopy = input;
        try {
            if (input instanceof String) {
                inputCopy = SalesforceUtils.createNewXMLStreamReader(((String)input).getBytes(StandardCharsets.UTF_8));
            } else if (input instanceof byte[]) {
                inputCopy = SalesforceUtils.createNewXMLStreamReader((byte[])input);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SalesforceTransformationException("Could not transform from " + (input == null ? "null" : input.getClass()) + " to XMLStreamReader!");
        }
        catch (XMLStreamException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SalesforceTransformationException("Could not transform from " + (input == null ? "null" : input.getClass()) + " to XMLStreamReader!");
        }
        try {
            streamReader = inputCopy instanceof NullPayload || inputCopy == null ? SalesforceUtils.getNullXmlStreamReaderMarker() : (XMLStreamReader)inputCopy;
        }
        catch (TransformerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SalesforceTransformationException("Could not transform from " + (input == null ? "null" : input.getClass()) + " to XMLStreamReader!");
        }
        ApexClient apexClient = this.config.getApexClient();
        return apexClient.invokeSoapMethod(soapMethodName, streamReader);
    }

    public Map<String, Object> invokeApexRestMethod(String restMethodName, @Nullable Object input, ApexRequestHeaders requestHeaders, Map<String, String> queryParameters) throws Exception {
        try {
            Map inputMap = input instanceof NullPayload || input == null ? Collections.emptyMap() : (Map)input;
            String[] metadataKey = restMethodName.split("-");
            if (metadataKey.length == 1) {
                throw new IllegalArgumentException("restMethodName parameter does not have the proper format (ClassName-MethodName): " + restMethodName);
            }
            String className = metadataKey[0] != null ? metadataKey[0] : "";
            String methodName = metadataKey[1] != null ? metadataKey[1] : "";
            String query = "SELECT ApiVersion,Body,Name FROM ApexClass WHERE Name = '" + className.trim() + "'";
            CustomPartnerConnection customPartnerConnection = this.getConfig().getCustomPartnerConnection();
            if (customPartnerConnection == null) {
                throw new ConnectionException("Connection not yet initialized.");
            }
            String classBody = ApexTypeUtils.fetchClassBody(customPartnerConnection, query);
            ApexClassType apexClass = ApexClassType.parse(classBody);
            ApexClient apexClient = this.getConfig().getApexClient();
            return apexClient.invokeRestMethod(methodName, apexClass, inputMap, requestHeaders, queryParameters);
        }
        catch (ClassCastException cce) {
            logger.error((Object)cce.getMessage(), (Throwable)cce);
            throw new SalesforceTransformationException("Could not transform from " + (input == null ? "null" : input.getClass()) + " to Map<String, Object>!");
        }
    }

    public void setTimeObjectStore(@NotNull ObjectStore<? extends Serializable> timeObjectStore) {
        this.timeObjectStore = timeObjectStore;
    }

    @NotNull
    private BatchInfo createBatchAndCompleteRequest(@NotNull JobInfo jobInfo, @NotNull List<Map<String, Object>> objects) throws Exception {
        BatchInfo result = jobInfo.getContentType() != null && jobInfo.getContentType().equals((Object)ContentType.CSV) ? this.createCSVBatchRequest(jobInfo, objects) : this.completeGeneralBatchRequest(jobInfo, objects);
        return result;
    }

    private BatchInfo completeGeneralBatchRequest(@NotNull JobInfo jobInfo, @NotNull List<Map<String, Object>> objects) throws AsyncApiException, SalesforceException {
        BatchRequest batchRequest = this.config.getBulkConnection().createBatch(jobInfo);
        batchRequest.addSObjects(SalesforceUtils.toAsyncSObjectList(objects, this.getBatchSobjectMaxDepth()));
        return batchRequest.completeRequest();
    }

    private InputStream createCsvFromMap(@NotNull List<Map<String, Object>> objects) {
        StringBuilder result = new StringBuilder();
        for (String string : objects.get(0).keySet()) {
            result = result.append(string);
            result = result.append(",");
        }
        result.setCharAt(result.length() - 1, '\n');
        for (Map map : objects) {
            for (String key : map.keySet()) {
                result = result.append(map.get(key));
                result = result.append(",");
            }
            result.setCharAt(result.length() - 1, '\n');
        }
        return new ByteArrayInputStream(result.toString().getBytes(StandardCharsets.UTF_8));
    }

    private BatchInfo createCSVBatchRequest(JobInfo jobInfo, List<Map<String, Object>> objects) throws Exception {
        InputStream input = this.createCsvFromMap(objects);
        return this.config.getBulkConnection().createBatchFromStream(jobInfo, input);
    }

    private BatchInfo createBatchForQuery(JobInfo jobInfo, InputStream query) throws AsyncApiException, SalesforceException {
        return this.config.getBulkConnection().createBatchFromStream(jobInfo, query);
    }

    private JobInfo createJobInfo(OperationEnum op, String type) throws AsyncApiException, SalesforceException {
        return this.createJobInfo(op, type, null, null, null);
    }

    private JobInfo createJobInfo(OperationEnum op, String type, String externalIdFieldName, ContentType contentType, ConcurrencyMode concurrencyMode) throws AsyncApiException, SalesforceException {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setOperation(op);
        jobInfo.setObject(type);
        if (externalIdFieldName != null) {
            jobInfo.setExternalIdFieldName(externalIdFieldName);
        }
        if (contentType != null) {
            jobInfo.setContentType(contentType);
        }
        if (concurrencyMode != null) {
            jobInfo.setConcurrencyMode(concurrencyMode);
        }
        return this.config.getBulkConnection().createJob(jobInfo);
    }

    protected SObject toSObject(String type, Map<String, Object> map) {
        SObject sObject = new SObject();
        sObject.setType(type);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if ("fieldsToNull".equals(key)) {
                sObject.setFieldsToNull((String[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                sObject.setField(key, (Object)this.toSObject(key, SalesforceUtils.toSObjectMap((Map)entry.getValue())));
                continue;
            }
            sObject.setField(key, entry.getValue());
        }
        return sObject;
    }

    @NotNull
    private ObjectStore<? extends Serializable> getObjectStore(@NotNull String username) {
        ObjectStore result = this.timeObjectStore;
        if (result == null) {
            MuleRegistry registry = this.getMuleContext().getRegistry();
            result = (ObjectStore)registry.lookupObject("_defaultUserObjectStore");
            if (result == null) {
                ObjectStoreManager storeManager = (ObjectStoreManager)registry.get("_muleObjectStoreManager");
                result = storeManager.getObjectStore(username, true);
            }
            if (result == null) {
                throw new IllegalArgumentException("Unable to acquire an object store.");
            }
            this.timeObjectStore = result;
        }
        return result;
    }

    public ObjectStore<? extends Serializable> getTimeObjectStore() {
        return this.timeObjectStore;
    }

    public Integer getBatchSobjectMaxDepth() {
        return this.batchSobjectMaxDepth;
    }

    public void setBatchSobjectMaxDepth(Integer batchSobjectMaxDepth) {
        this.batchSobjectMaxDepth = batchSobjectMaxDepth;
    }

    @NotNull
    private CustomPartnerConnection buildPartnerConnection() {
        return this.buildPartnerConnection(new HashMap<SalesforceHeader, Object>());
    }

    @NotNull
    public CustomPartnerConnection buildPartnerConnection(@NotNull Map<SalesforceHeader, Object> headers) {
        return SalesforceSoapAdapter.adapt(this.config.getCustomPartnerConnection(), headers, this.config);
    }

    public static Transformer transformerResolver(@NotNull DataType source, @NotNull DataType resultDataType, @NotNull MuleContext muleContext) throws MuleException {
        AbstractDiscoverableTransformer result = null;
        if (source.isCompatibleWith(SaveResultToBulkOperationTransformer.SAVE_RESULT_COLLECTION_DATE_TYPE) && resultDataType.isCompatibleWith(SalesforceUtils.BULK_OPERATION_RESULT_DATA_TYPE)) {
            result = new SaveResultToBulkOperationTransformer();
            muleContext.getRegistry().registerTransformer((Transformer)result);
        } else if (source.isCompatibleWith(UpsertResultToBulkOperationTransformer.UPSERT_RESULT_COLLECTION_DATE_TYPE) && resultDataType.isCompatibleWith(SalesforceUtils.BULK_OPERATION_RESULT_DATA_TYPE)) {
            result = new UpsertResultToBulkOperationTransformer();
            muleContext.getRegistry().registerTransformer((Transformer)result);
        }
        return result;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

