/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cometd.2_2.shade.bayeux.Message;
import org.cometd.2_2.shade.bayeux.client.ClientSessionChannel;
import org.cometd.2_2.shade.common.HashMapMessage;
import org.mule.api.callback.SourceCallback;

public class SalesforceBayeuxMessageListener
implements ClientSessionChannel.MessageListener {
    private static final Logger logger = Logger.getLogger(SalesforceBayeuxMessageListener.class);
    private final SourceCallback callback;

    public SalesforceBayeuxMessageListener(SourceCallback callback) {
        this.callback = callback;
    }

    @Override
    public void onMessage(ClientSessionChannel channel, Message message) {
        try {
            if (message instanceof HashMapMessage) {
                HashMapMessage hashMapMessage = (HashMapMessage)message;
                HashMap inboundProperties = new HashMap();
                if (!hashMapMessage.containsKey("channel")) {
                    logger.error((Object)"The event does not contain the channel");
                } else {
                    inboundProperties.put("channel", hashMapMessage.get("channel"));
                }
                if (!hashMapMessage.containsKey("data")) {
                    logger.error((Object)"The event does not contain any data?");
                } else {
                    HashMap data = (HashMap)hashMapMessage.get("data");
                    Map sObject = (Map)data.get("sobject");
                    Map event = (Map)data.get("event");
                    if (sObject == null) {
                        logger.error((Object)"The data of the event does not contain an SObject");
                    } else if (event == null) {
                        logger.error((Object)"The data of the event does not contain event information");
                    } else {
                        for (Map.Entry entry : event.entrySet()) {
                            inboundProperties.put((String)entry.getKey(), entry.getValue());
                        }
                        this.callback.process((Object)sObject, inboundProperties);
                    }
                }
            } else {
                this.callback.process(message.getData());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

