/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.ws.ConnectorConfig;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cometd.2_2.shade.bayeux.Message;
import org.cometd.2_2.shade.bayeux.client.ClientSessionChannel;
import org.cometd.2_2.shade.client.BayeuxClient;
import org.cometd.2_2.shade.client.transport.ClientTransport;
import org.mule.modules.salesforce.Config;
import org.mule.modules.salesforce.SalesforceLongPollingTransport;
import org.mule.modules.salesforce.config.CustomPartnerConnection;

public class SalesforceBayeuxClient
extends BayeuxClient {
    protected static final int HANDSHAKE_TIMEOUT = 30000;
    protected static final int LONG_POLLING_TIMEOUT = 120000;
    protected static final Map<String, Object> LONG_POLLING_OPTIONS = SalesforceBayeuxClient.createLongPollingOptions();
    private static final Logger logger = Logger.getLogger(SalesforceBayeuxClient.class);
    protected static final String LOGIN_COOKIE = "login";
    protected static final String LOCALEINFO_COOKIE = "com.salesforce.LocaleInfo";
    protected static final String SESSIONID_COOKIE = "sid";
    protected static final String LANGUAGE_COOKIE = "language";
    protected Map<String, ClientSessionChannel.MessageListener> subscriptions;
    protected Map<String, ClientSessionChannel.MessageListener> currentSubscriptions;
    protected Config config;
    protected ConnectorConfig connectorConfig;
    private boolean needToResubscribe = false;

    private static Map<String, Object> createLongPollingOptions() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("timeout", 120000);
        return Collections.unmodifiableMap(result);
    }

    public SalesforceBayeuxClient(Config config, String serviceUrl) throws MalformedURLException {
        super(serviceUrl, SalesforceLongPollingTransport.create(config, LONG_POLLING_OPTIONS), new ClientTransport[0]);
        CustomPartnerConnection customPartnerConnection;
        this.config = config;
        this.subscriptions = Collections.synchronizedMap(new HashMap());
        this.currentSubscriptions = Collections.synchronizedMap(new HashMap());
        if (config != null && (customPartnerConnection = config.getCustomPartnerConnection()) != null) {
            this.connectorConfig = customPartnerConnection.getConfig();
        }
        this.setCookies();
        this.getChannel("/meta/connect").addListener(new ClientSessionChannel.MessageListener(){

            @Override
            public void onMessage(ClientSessionChannel channel, Message message) {
                logger.debug((Object)("### new message:: " + message.getId()));
                logger.debug((Object)("isSuccessful: " + message.isSuccessful()));
                logger.debug((Object)("state: " + (Object)((Object)SalesforceBayeuxClient.this.getState())));
                logger.debug((Object)("isConnected: " + SalesforceBayeuxClient.this.isConnected()));
                logger.debug((Object)("needToResubscribe: " + SalesforceBayeuxClient.this.needToResubscribe));
                if (message.isSuccessful() && !SalesforceBayeuxClient.this.subscriptions.isEmpty()) {
                    for (String subscriptionChannel : SalesforceBayeuxClient.this.subscriptions.keySet()) {
                        logger.info((Object)("subscribing " + subscriptionChannel + " for the first time"));
                        SalesforceBayeuxClient.this.getChannel(subscriptionChannel).subscribe(SalesforceBayeuxClient.this.subscriptions.get(subscriptionChannel));
                    }
                    SalesforceBayeuxClient.this.subscriptions.clear();
                } else if (!message.isSuccessful() && SalesforceBayeuxClient.this.getState() == BayeuxClient.State.REHANDSHAKING) {
                    SalesforceBayeuxClient.this.needToResubscribe = true;
                } else if (SalesforceBayeuxClient.this.needToResubscribe && SalesforceBayeuxClient.this.isConnected()) {
                    SalesforceBayeuxClient.this.resubscribe();
                    SalesforceBayeuxClient.this.needToResubscribe = false;
                }
            }
        });
    }

    private void resubscribe() {
        for (String subscriptionChannel : this.currentSubscriptions.keySet()) {
            logger.info((Object)("Re-Subscribing to channel: " + subscriptionChannel));
            this.getChannel(subscriptionChannel).subscribe(this.currentSubscriptions.get(subscriptionChannel));
        }
    }

    private void setCookies() {
        this.setCookie(LOCALEINFO_COOKIE, "us");
        if (this.connectorConfig != null) {
            this.setCookie(LOGIN_COOKIE, this.connectorConfig.getUsername());
        }
        this.setCookie(SESSIONID_COOKIE, this.config.getSessionId());
        this.setCookie(LANGUAGE_COOKIE, "en_US");
    }

    @Override
    public void onFailure(Throwable x, Message[] messages) {
        logger.error((Object)x.getMessage(), x);
    }

    @Override
    public void handshake() {
        super.handshake(30000L);
    }

    public void unsubscribe(String channel) {
        this.getChannel(channel).unsubscribe();
        this.subscriptions.remove(channel);
        this.currentSubscriptions.remove(channel);
    }

    public void subscribe(String channel, ClientSessionChannel.MessageListener messageListener) {
        if (this.isConnected()) {
            logger.info((Object)("Subscribing to channel: " + channel));
            this.getChannel(channel).subscribe(messageListener);
        } else {
            this.subscriptions.put(channel, messageListener);
            this.currentSubscriptions.put(channel, messageListener);
        }
    }
}

