/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.soap.partner.GetUpdatedResult;
import java.io.Serializable;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;

public class ObjectStoreHelper<T extends Serializable> {
    private static final String LATEST_UPDATE_TIME_KEY = "latestUpdateTime";
    private static final String LATEST_UPDATE_TIME_BACKUP_KEY = "latestUpdateTimeBackup";
    private final ObjectStore<T> objectStore;
    private final String keyPrefix;

    private ObjectStoreHelper(@NotNull String keyPrefix, @NotNull ObjectStore<T> objectStore) {
        this.keyPrefix = keyPrefix + '-';
        this.objectStore = objectStore;
    }

    @NotNull
    public static <T extends Serializable> ObjectStoreHelper<T> create(@NotNull String keyPrefix, @NotNull ObjectStore<T> objectStore) {
        return new ObjectStoreHelper<T>(keyPrefix, objectStore);
    }

    public void updateTimestamp(@NotNull GetUpdatedResult updatedResult, @NotNull String type) throws ObjectStoreException {
        String lastUpdateTimeKey = this.getLastUpdateTimeKey(type);
        if (this.objectStore.contains((Serializable)((Object)lastUpdateTimeKey))) {
            String backupKey = this.getLatestUpdateTimeBackupKey(type);
            if (this.objectStore.contains((Serializable)((Object)backupKey))) {
                this.objectStore.remove((Serializable)((Object)backupKey));
            }
            Serializable lastUpdateTimeValue = this.objectStore.retrieve((Serializable)((Object)lastUpdateTimeKey));
            this.objectStore.store((Serializable)((Object)backupKey), lastUpdateTimeValue);
            this.objectStore.remove((Serializable)((Object)lastUpdateTimeKey));
        }
        Calendar latestDateCovered = updatedResult.getLatestDateCovered();
        this.objectStore.store((Serializable)((Object)lastUpdateTimeKey), (Serializable)latestDateCovered);
    }

    @Nullable
    public Calendar getTimestamp(String type) throws ObjectStoreException {
        if (this.objectStore.contains((Serializable)((Object)this.getLastUpdateTimeKey(type)))) {
            return (Calendar)this.objectStore.retrieve((Serializable)((Object)this.getLastUpdateTimeKey(type)));
        }
        if (this.objectStore.contains((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)))) {
            return (Calendar)this.objectStore.retrieve((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)));
        }
        return null;
    }

    public void resetTimestamps(@NotNull String type) throws ObjectStoreException {
        if (this.objectStore.contains((Serializable)((Object)this.getLastUpdateTimeKey(type)))) {
            this.objectStore.remove((Serializable)((Object)this.getLastUpdateTimeKey(type)));
        }
        if (this.objectStore.contains((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)))) {
            this.objectStore.remove((Serializable)((Object)this.getLatestUpdateTimeBackupKey(type)));
        }
    }

    @NotNull
    public String getLastUpdateTimeKey(@NotNull String type) {
        return this.keyPrefix + '/' + type + '/' + LATEST_UPDATE_TIME_KEY;
    }

    @NotNull
    public String getLatestUpdateTimeBackupKey(@NotNull String type) {
        return this.keyPrefix + '/' + type + '/' + LATEST_UPDATE_TIME_BACKUP_KEY;
    }
}

