/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.soap.metadata.AsyncResult;
import com.sforce.soap.metadata.CodeCoverageWarning;
import com.sforce.soap.metadata.DeleteResult;
import com.sforce.soap.metadata.DeployDetails;
import com.sforce.soap.metadata.DeployMessage;
import com.sforce.soap.metadata.DeployOptions;
import com.sforce.soap.metadata.DeployResult;
import com.sforce.soap.metadata.Metadata;
import com.sforce.soap.metadata.Package;
import com.sforce.soap.metadata.PackageTypeMembers;
import com.sforce.soap.metadata.ReadResult;
import com.sforce.soap.metadata.RetrieveMessage;
import com.sforce.soap.metadata.RetrieveRequest;
import com.sforce.soap.metadata.RetrieveResult;
import com.sforce.soap.metadata.RetrieveStatus;
import com.sforce.soap.metadata.RunTestFailure;
import com.sforce.soap.metadata.RunTestsResult;
import com.sforce.soap.metadata.SaveResult;
import com.sforce.soap.metadata.UpsertResult;
import com.sforce.ws.ConnectionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.mule.modules.salesforce.MetadataOperationType;
import org.mule.modules.salesforce.MetadataType;
import org.mule.modules.salesforce.config.CustomMetadataConnection;
import org.mule.modules.salesforce.exception.SalesforceException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MetadataServiceUtil {
    private static final Logger logger = Logger.getLogger(MetadataServiceUtil.class);
    private static final long ONE_SECOND = 1000L;
    private static final int MAX_NUM_POLL_REQUESTS = 50;
    private static final double API_VERSION = 31.0;

    private MetadataServiceUtil() {
    }

    @NotNull
    public static List<SaveResult> callCreateUpdateService(@NotNull CustomMetadataConnection connection, @NotNull String type, @NotNull List<Map<String, Object>> request, @NotNull MetadataOperationType metadataOperation) throws NoSuchMethodException, IllegalAccessException, SalesforceException, InvocationTargetException, ConnectionException {
        List<SaveResult> results;
        MetadataType metadataType = MetadataType.valueOf(type);
        switch (metadataOperation) {
            case CREATE: {
                results = Arrays.asList(connection.createMetadata(MetadataServiceUtil.getMetadataObjects(metadataType, request)));
                break;
            }
            case UPDATE: {
                results = Arrays.asList(connection.updateMetadata(MetadataServiceUtil.getMetadataObjects(metadataType, request)));
                break;
            }
            default: {
                results = Collections.emptyList();
            }
        }
        return results;
    }

    @NotNull
    public static List<UpsertResult> callUpsertService(CustomMetadataConnection connection, String type, List<Map<String, Object>> request) throws Exception {
        MetadataType metadataType = MetadataType.valueOf(type);
        return Arrays.asList(connection.upsertMetadata(MetadataServiceUtil.getMetadataObjects(metadataType, request)));
    }

    @NotNull
    public static List<DeleteResult> callDeleteService(CustomMetadataConnection connection, String type, List<String> fullNames) throws Exception {
        MetadataType metadataType = MetadataType.valueOf(type);
        return Arrays.asList(connection.deleteMetadata(metadataType.getDisplayName(), fullNames.toArray(new String[fullNames.size()])));
    }

    @NotNull
    public static ReadResult callReadService(CustomMetadataConnection connection, String type, List<String> fullNames) throws Exception {
        MetadataType metadataType = MetadataType.valueOf(type);
        return connection.readMetadata(metadataType.getDisplayName(), fullNames.toArray(new String[fullNames.size()]));
    }

    @NotNull
    public static SaveResult callRenameService(CustomMetadataConnection connection, String type, String oldFullName, String newFullName) throws Exception {
        MetadataType metadataType = MetadataType.valueOf(type);
        return connection.renameMetadata(metadataType.getDisplayName(), oldFullName, newFullName);
    }

    @NotNull
    public static void callDeployService(CustomMetadataConnection connection, InputStream stream) throws Exception {
        String error;
        boolean fetchDetails;
        DeployResult deployResult;
        byte[] zipBytes = IOUtils.toByteArray((InputStream)stream);
        DeployOptions deployOptions = new DeployOptions();
        deployOptions.setPerformRetrieve(false);
        deployOptions.setRollbackOnError(true);
        AsyncResult asyncResult = connection.deploy(zipBytes, deployOptions);
        String asyncResultId = asyncResult.getId();
        StringBuilder errorMessageBuilder = new StringBuilder();
        int poll = 0;
        long waitTimeMilliSecs = 1000L;
        do {
            Thread.sleep(waitTimeMilliSecs);
            waitTimeMilliSecs *= 2L;
            if (poll++ > 50) {
                throw new Exception("Request timed out. If this is a large set of metadata components, check that the time allowed by MAX_NUM_POLL_REQUESTS is sufficient.");
            }
            fetchDetails = poll % 3 == 0;
            deployResult = connection.checkDeployStatus(asyncResultId, fetchDetails);
            if (deployResult.isDone() || !fetchDetails || "".equals(error = MetadataServiceUtil.getErrors(deployResult, "Failures for deployment in progress:\n"))) continue;
            errorMessageBuilder.append(error);
        } while (!deployResult.isDone());
        if (!deployResult.isSuccess() && deployResult.getErrorStatusCode() != null) {
            throw new Exception(deployResult.getErrorStatusCode() + " msg: " + deployResult.getErrorMessage());
        }
        if (!fetchDetails) {
            deployResult = connection.checkDeployStatus(asyncResultId, true);
        }
        if (!deployResult.isSuccess()) {
            error = MetadataServiceUtil.getErrors(deployResult, "Final list of failures:\n");
            errorMessageBuilder.append(error);
            throw new Exception("The files were not successfully deployed\n" + errorMessageBuilder.toString());
        }
    }

    public static InputStream callRetrieveService(CustomMetadataConnection connection, List<String> packageNames, List<String> specificFiles, InputStream unpackaged) throws Exception {
        RetrieveResult result;
        RetrieveRequest retrieveRequest = new RetrieveRequest();
        retrieveRequest.setApiVersion(31.0);
        if (specificFiles != null && !specificFiles.isEmpty()) {
            if (packageNames != null && !packageNames.isEmpty()) {
                throw new Exception("If a value is specified for specific files, packageNames must be set to null");
            }
            retrieveRequest.setSinglePackage(true);
            retrieveRequest.setSpecificFiles(specificFiles.toArray(new String[specificFiles.size()]));
        } else if (packageNames != null && !packageNames.isEmpty()) {
            retrieveRequest.setPackageNames(packageNames.toArray(new String[packageNames.size()]));
        }
        if (unpackaged != null) {
            MetadataServiceUtil.setUnpackaged(retrieveRequest, unpackaged);
        }
        AsyncResult asyncResult = connection.retrieve(retrieveRequest);
        String asyncResultId = asyncResult.getId();
        int poll = 0;
        long waitTimeMilliSecs = 1000L;
        do {
            Thread.sleep(waitTimeMilliSecs);
            waitTimeMilliSecs *= 2L;
            if (poll++ <= 50) continue;
            throw new Exception("Request timed out. If this is a large set of metadata components, check that the time allowed by MAX_NUM_POLL_REQUESTS is sufficient.");
        } while (!(result = connection.checkRetrieveStatus(asyncResultId)).isDone());
        if (result.getStatus() == RetrieveStatus.Failed) {
            throw new Exception(result.getErrorStatusCode() + " msg: " + result.getErrorMessage());
        }
        if (result.getStatus() == RetrieveStatus.Succeeded) {
            StringBuilder buf = new StringBuilder();
            if (result.getMessages() != null) {
                for (RetrieveMessage rm : result.getMessages()) {
                    buf.append(rm.getFileName() + " - " + rm.getProblem());
                }
            }
            if (buf.length() > 0) {
                logger.debug((Object)("Retrieve warnings:\n" + buf));
            }
        }
        return new ByteArrayInputStream(result.getZipFile());
    }

    private static void setUnpackaged(RetrieveRequest request, InputStream unpackaged) throws Exception {
        try {
            ArrayList<PackageTypeMembers> pd = new ArrayList<PackageTypeMembers>();
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element d = db.parse(unpackaged).getDocumentElement();
            for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                Element ce;
                NodeList namee;
                if (!(c instanceof Element) || (namee = (ce = (Element)c).getElementsByTagName("name")).getLength() == 0) continue;
                String name = namee.item(0).getTextContent();
                NodeList m = ce.getElementsByTagName("members");
                ArrayList<String> members = new ArrayList<String>();
                for (int i = 0; i < m.getLength(); ++i) {
                    Node mm = m.item(i);
                    members.add(mm.getTextContent());
                }
                PackageTypeMembers pdi = new PackageTypeMembers();
                pdi.setName(name);
                pdi.setMembers(members.toArray(new String[members.size()]));
                pd.add(pdi);
            }
            Package r = new Package();
            r.setTypes(pd.toArray(new PackageTypeMembers[pd.size()]));
            r.setVersion("31.0");
            request.setUnpackaged(r);
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("Cannot create XML parser", pce);
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
        catch (SAXException se) {
            throw new Exception(se);
        }
    }

    private static String getErrors(DeployResult result, String messageHeader) {
        DeployDetails deployDetails = result.getDetails();
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (deployDetails != null) {
            String n;
            DeployMessage[] componentFailures;
            for (DeployMessage message : componentFailures = deployDetails.getComponentFailures()) {
                String loc;
                String string = loc = message.getLineNumber() == 0 ? "" : "(" + message.getLineNumber() + "," + message.getColumnNumber() + ")";
                if (loc.length() == 0 && !message.getFileName().equals(message.getFullName())) {
                    loc = "(" + message.getFullName() + ")";
                }
                errorMessageBuilder.append(message.getFileName() + loc + ":" + message.getProblem()).append('\n');
            }
            RunTestsResult rtr = deployDetails.getRunTestResult();
            if (rtr.getFailures() != null) {
                for (RunTestFailure failure : rtr.getFailures()) {
                    n = (failure.getNamespace() == null ? "" : failure.getNamespace() + ".") + failure.getName();
                    errorMessageBuilder.append("Test failure, method: " + n + "." + failure.getMethodName() + " -- " + failure.getMessage() + " stack " + failure.getStackTrace() + "\n\n");
                }
            }
            if (rtr.getCodeCoverageWarnings() != null) {
                for (CodeCoverageWarning ccw : rtr.getCodeCoverageWarnings()) {
                    errorMessageBuilder.append("Code coverage issue");
                    if (ccw.getName() != null) {
                        n = (ccw.getNamespace() == null ? "" : ccw.getNamespace() + ".") + ccw.getName();
                        errorMessageBuilder.append(", class: " + n);
                    }
                    errorMessageBuilder.append(" -- " + ccw.getMessage() + "\n");
                }
            }
        }
        if (errorMessageBuilder.length() > 0) {
            errorMessageBuilder.insert(0, messageHeader);
            return errorMessageBuilder.toString();
        }
        return "";
    }

    public static Metadata[] getMetadataObjects(MetadataType metadataType, List<Map<String, Object>> objects) throws InvocationTargetException, NoSuchMethodException, SalesforceException, IllegalAccessException {
        BeanUtilsBean beanUtilsBean = new BeanUtilsBean(new ConvertUtilsBean(){

            public Object convert(String value, Class clazz) {
                if (clazz.isEnum()) {
                    return Enum.valueOf(clazz, value);
                }
                return super.convert(value, clazz);
            }
        });
        Metadata[] mobjects = new Metadata[objects.size()];
        int s = 0;
        for (Map<String, Object> map : objects) {
            Object metadataObject = MetadataServiceUtil.toMetadataObject(beanUtilsBean, metadataType, map);
            mobjects[s] = (Metadata)metadataObject;
            ++s;
        }
        return mobjects;
    }

    private static <T> Object toMetadataObject(BeanUtilsBean beanUtilsBean, MetadataType metadataType, Map<String, Object> map) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, SalesforceException {
        Object metadataObject = metadataType.getMetadataObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() instanceof Map) {
                PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
                Class childClass = propertyUtilsBean.getPropertyType(metadataObject, key);
                MetadataType childType = MetadataType.getByClass(childClass);
                if (childType == null) continue;
                beanUtilsBean.setProperty(metadataObject, key, MetadataServiceUtil.toMetadataObject(beanUtilsBean, childType, MetadataServiceUtil.toMObjectMap((Map)entry.getValue())));
                continue;
            }
            if (entry.getValue() instanceof List) {
                List objectsList = (List)entry.getValue();
                Object[] mobjects = new Object[objectsList.size()];
                int s = 0;
                Class<?> metadataClass = null;
                for (Object objectEntry : objectsList) {
                    MetadataType childType;
                    if (!(objectEntry instanceof Map)) continue;
                    PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
                    Class<?> childClass = propertyUtilsBean.getPropertyType(metadataObject, key);
                    if (childClass != null && childClass.isArray()) {
                        childClass = childClass.getComponentType();
                    }
                    if (metadataClass == null) {
                        metadataClass = childClass;
                    }
                    if ((childType = MetadataType.getByClass(metadataClass)) == null) continue;
                    mobjects[s] = MetadataServiceUtil.toMetadataObject(beanUtilsBean, childType, MetadataServiceUtil.toMObjectMap((Map)objectEntry));
                    ++s;
                }
                if (metadataClass != null) {
                    Object[] metadataChildObjects = (Object[])Array.newInstance(metadataClass, mobjects.length);
                    for (int i = 0; i < mobjects.length; ++i) {
                        metadataChildObjects[i] = metadataClass.cast(mobjects[i]);
                    }
                    beanUtilsBean.setProperty(metadataObject, key, (Object)metadataChildObjects);
                    continue;
                }
                beanUtilsBean.setProperty(metadataObject, key, entry.getValue());
                continue;
            }
            beanUtilsBean.setProperty(metadataObject, key, entry.getValue());
        }
        return metadataObject;
    }

    @NotNull
    public static Map<String, Object> toMObjectMap(@NotNull Map<Object, Object> map) {
        HashMap<String, Object> mObjectMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            mObjectMap.put(entry.getKey().toString(), entry.getValue());
        }
        return mObjectMap;
    }
}

