/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientService {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientService.class);
    private static final String COOKIE_HEADER = "Cookie";
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private Integer connectionTimeout;
    private Integer readTimeout;

    public HttpClientService(String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword, Integer connectionTimeout, Integer readTimeout) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    public InputStream sendPost(String uri, NameValuePair[] nameValuePairs, Map<String, String> headers, Map<String, String> cookies) throws IOException {
        PostMethod post = new PostMethod(uri);
        post.setRequestBody(nameValuePairs);
        this.setCookies((HttpMethod)post, cookies);
        this.setHeaders((HttpMethod)post, headers);
        return this.executeMethod((HttpMethod)post);
    }

    public InputStream send(HttpMethod method, String uri, String body, Map<String, String> headers, Map<String, String> cookies) throws IOException {
        HttpClient httpClient = this.getHttpClient();
        method.setURI(new URI(uri, true, "UTF-8"));
        this.setCookies(method, cookies);
        this.setHeaders(method, headers);
        if (method instanceof EntityEnclosingMethod) {
            ((EntityEnclosingMethod)method).setRequestEntity((RequestEntity)new StringRequestEntity(body, "application/json", "UTF-8"));
        }
        try {
            int statusCode = httpClient.executeMethod(method);
            if (statusCode != 200) {
                throw new IOException(String.format("Invalid status code: %d, response body: %s", statusCode, method.getResponseBodyAsString()));
            }
            InputStream response = method.getResponseBodyAsStream();
            return response;
        }
        catch (IOException e) {
            logger.error("Failed sending request.", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public InputStream sendGet(String uri, Map<String, String> headers, Map<String, String> cookies) throws IOException {
        GetMethod getMethod = new GetMethod(uri);
        this.setCookies((HttpMethod)getMethod, cookies);
        this.setHeaders((HttpMethod)getMethod, headers);
        return this.executeMethod((HttpMethod)getMethod);
    }

    private InputStream executeMethod(HttpMethod method) throws IOException {
        try {
            HttpClient httpClient = this.getHttpClient();
            int statusCode = httpClient.executeMethod(method);
            if (statusCode != 200) {
                throw new IOException(String.format("Invalid status code: %d, response body: %s", statusCode, method.getResponseBodyAsString()));
            }
            return this.getResponseStream(method);
        }
        catch (IOException e) {
            logger.error("Failed sending get request.", (Throwable)e);
            throw e;
        }
    }

    private HttpClient getHttpClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout.intValue());
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(this.readTimeout.intValue());
        if (this.proxyHost != null) {
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setProxy(this.proxyHost, this.proxyPort.intValue());
            httpClient.setHostConfiguration(hostConfiguration);
            if (this.proxyUsername != null && this.proxyPassword != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
            }
        }
        return httpClient;
    }

    private void setHeaders(HttpMethod method, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                method.setRequestHeader(header.getKey(), header.getValue());
            }
        }
    }

    private void setCookies(HttpMethod method, Map<String, String> cookies) {
        if (cookies != null) {
            StringBuilder cookiesValue = new StringBuilder();
            for (Map.Entry<String, String> cookie : cookies.entrySet()) {
                cookiesValue.append(String.format("%s=%s", cookie.getKey(), cookie.getValue()));
                cookiesValue.append(";");
            }
            if (cookiesValue.length() != 0) {
                cookiesValue.deleteCharAt(cookiesValue.length() - 1);
                method.setRequestHeader(COOKIE_HEADER, cookiesValue.toString());
            }
        }
    }

    @NotNull
    private InputStream getResponseStream(HttpMethod method) throws IOException {
        InputStream result = null;
        Header contentEncoding = method.getResponseHeader("Content-Encoding");
        if (contentEncoding != null) {
            String acceptEncodingValue = contentEncoding.getValue();
            result = acceptEncodingValue.contains("gzip") ? new GZIPInputStream(method.getResponseBodyAsStream()) : method.getResponseBodyAsStream();
        }
        if (result == null || result.available() == 0) {
            throw new IOException("Empty stream came as response");
        }
        return result;
    }
}

