/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce;

import com.sforce.async.AsyncApiException;
import com.sforce.async.AsyncExceptionCode;
import com.sforce.soap.partner.fault.ExceptionCode;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.mule.api.annotations.Handle;
import org.mule.api.annotations.components.Handler;
import org.mule.modules.salesforce.exception.SalesforceException;
import org.mule.modules.salesforce.exception.SalesforceSessionExpiredException;

@Handler
public class ExceptionDecorator {
    private static final Logger logger = Logger.getLogger(ExceptionDecorator.class);
    private static final String INVALID_SESSION_ID_MESSAGE = "Invalid Session ID found in SessionHeader";

    @NotNull
    public static SalesforceException decorateException(@NotNull Exception exception) {
        logger.debug((Object)("Analyzing exception " + exception.getClass()));
        SalesforceException result = ExceptionDecorator.hasSessionExpired(exception) ? new SalesforceSessionExpiredException(exception) : (exception instanceof SalesforceException ? (SalesforceException)exception : new SalesforceException(exception));
        logger.debug((Object)"Exception handler result");
        logger.debug((Object)result);
        return result;
    }

    public static boolean hasSessionExpired(@NotNull Throwable exception) {
        Throwable cause;
        boolean result = false;
        if (exception instanceof AsyncApiException) {
            result = ((AsyncApiException)exception).getExceptionCode() == AsyncExceptionCode.InvalidSessionId;
        } else if (exception instanceof UnexpectedErrorFault) {
            boolean bl = result = ((UnexpectedErrorFault)exception).getExceptionCode() == ExceptionCode.INVALID_SESSION_ID;
        }
        if (!result) {
            String message = ExceptionDecorator.extractMsg(exception);
            result = StringUtils.contains((String)message, (String)INVALID_SESSION_ID_MESSAGE);
        }
        if (!result && (cause = exception.getCause()) != null) {
            result = ExceptionDecorator.hasSessionExpired(cause);
        }
        return result;
    }

    @NotNull
    private static String extractMsg(@NotNull Throwable exception) {
        return exception.getLocalizedMessage() != null ? exception.getLocalizedMessage() : exception.getMessage();
    }

    @Handle
    public void process(@NotNull Exception value) throws Exception {
        throw ExceptionDecorator.decorateException(value);
    }
}

