/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.8_1_13_v20130916.shade.util.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public class AliasedX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private String _keyAlias;
    private X509KeyManager _keyManager;

    public AliasedX509ExtendedKeyManager(String keyAlias, X509KeyManager keyManager) throws Exception {
        this._keyAlias = keyAlias;
        this._keyManager = keyManager;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this._keyAlias == null ? this._keyManager.chooseClientAlias(keyType, issuers, socket) : this._keyAlias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this._keyAlias == null ? this._keyManager.chooseServerAlias(keyType, issuers, socket) : this._keyAlias;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this._keyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this._keyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this._keyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this._keyManager.getPrivateKey(alias);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this._keyAlias == null ? super.chooseEngineServerAlias(keyType, issuers, engine) : this._keyAlias;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this._keyAlias == null ? super.chooseEngineClientAlias(keyType, issuers, engine) : this._keyAlias;
    }
}

