/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.8_1_13_v20130916.shade.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.8_1_13_v20130916.shade.util.Attributes;

public class AttributesMap
implements Attributes {
    protected final Map<String, Object> _map;

    public AttributesMap() {
        this._map = new HashMap<String, Object>();
    }

    public AttributesMap(Map<String, Object> map) {
        this._map = map;
    }

    public AttributesMap(AttributesMap map) {
        this._map = new HashMap<String, Object>(map._map);
    }

    @Override
    public void removeAttribute(String name) {
        this._map.remove(name);
    }

    @Override
    public void setAttribute(String name, Object attribute) {
        if (attribute == null) {
            this._map.remove(name);
        } else {
            this._map.put(name, attribute);
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this._map.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this._map.keySet());
    }

    public Set<String> getAttributeNameSet() {
        return this._map.keySet();
    }

    public Set<Map.Entry<String, Object>> getAttributeEntrySet() {
        return this._map.entrySet();
    }

    public static Enumeration<String> getAttributeNamesCopy(Attributes attrs) {
        if (attrs instanceof AttributesMap) {
            return Collections.enumeration(((AttributesMap)attrs)._map.keySet());
        }
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(Collections.list(attrs.getAttributeNames()));
        return Collections.enumeration(names);
    }

    @Override
    public void clearAttributes() {
        this._map.clear();
    }

    public int size() {
        return this._map.size();
    }

    public String toString() {
        return this._map.toString();
    }

    public Set<String> keySet() {
        return this._map.keySet();
    }

    public void addAll(Attributes attributes) {
        Enumeration<String> e = attributes.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            this.setAttribute(name, attributes.getAttribute(name));
        }
    }
}

