/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.8_1_13_v20130916.shade.io;

import org.eclipse.jetty.8_1_13_v20130916.shade.io.AbstractBuffer;
import org.eclipse.jetty.8_1_13_v20130916.shade.io.Buffer;

public class View
extends AbstractBuffer {
    Buffer _buffer;

    public View(Buffer buffer, int mark, int get, int put, int access) {
        super(2, !buffer.isImmutable());
        this._buffer = buffer.buffer();
        this.setPutIndex(put);
        this.setGetIndex(get);
        this.setMarkIndex(mark);
        this._access = access;
    }

    public View(Buffer buffer) {
        super(2, !buffer.isImmutable());
        this._buffer = buffer.buffer();
        this.setPutIndex(buffer.putIndex());
        this.setGetIndex(buffer.getIndex());
        this.setMarkIndex(buffer.markIndex());
        this._access = buffer.isReadOnly() ? 1 : 2;
    }

    public View() {
        super(2, true);
    }

    public void update(Buffer buffer) {
        this._access = 2;
        this._buffer = buffer.buffer();
        this.setGetIndex(0);
        this.setPutIndex(buffer.putIndex());
        this.setGetIndex(buffer.getIndex());
        this.setMarkIndex(buffer.markIndex());
        this._access = buffer.isReadOnly() ? 1 : 2;
    }

    public void update(int get, int put) {
        int a = this._access;
        this._access = 2;
        this.setGetIndex(0);
        this.setPutIndex(put);
        this.setGetIndex(get);
        this.setMarkIndex(-1);
        this._access = a;
    }

    @Override
    public byte[] array() {
        return this._buffer.array();
    }

    @Override
    public Buffer buffer() {
        return this._buffer.buffer();
    }

    @Override
    public int capacity() {
        return this._buffer.capacity();
    }

    @Override
    public void clear() {
        this.setMarkIndex(-1);
        this.setGetIndex(0);
        this.setPutIndex(this._buffer.getIndex());
        this.setGetIndex(this._buffer.getIndex());
    }

    @Override
    public void compact() {
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Buffer && obj.equals(this) || super.equals(obj);
    }

    @Override
    public boolean isReadOnly() {
        return this._buffer.isReadOnly();
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    @Override
    public byte peek(int index) {
        return this._buffer.peek(index);
    }

    @Override
    public int peek(int index, byte[] b, int offset, int length) {
        return this._buffer.peek(index, b, offset, length);
    }

    @Override
    public Buffer peek(int index, int length) {
        return this._buffer.peek(index, length);
    }

    @Override
    public int poke(int index, Buffer src) {
        return this._buffer.poke(index, src);
    }

    @Override
    public void poke(int index, byte b) {
        this._buffer.poke(index, b);
    }

    @Override
    public int poke(int index, byte[] b, int offset, int length) {
        return this._buffer.poke(index, b, offset, length);
    }

    @Override
    public String toString() {
        if (this._buffer == null) {
            return "INVALID";
        }
        return super.toString();
    }

    public static class CaseInsensitive
    extends View
    implements Buffer.CaseInsensitve {
        public CaseInsensitive() {
        }

        public CaseInsensitive(Buffer buffer, int mark, int get, int put, int access) {
            super(buffer, mark, get, put, access);
        }

        public CaseInsensitive(Buffer buffer) {
            super(buffer);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj instanceof Buffer && ((Buffer)obj).equalsIgnoreCase(this) || super.equals(obj);
        }
    }
}

