/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.8_1_13_v20130916.shade.client;

import java.io.IOException;
import org.eclipse.jetty.8_1_13_v20130916.shade.client.HttpEventListener;
import org.eclipse.jetty.8_1_13_v20130916.shade.io.Buffer;

public class HttpEventListenerWrapper
implements HttpEventListener {
    HttpEventListener _listener;
    boolean _delegatingRequests;
    boolean _delegatingResponses;
    boolean _delegationResult = true;
    private Buffer _version;
    private int _status;
    private Buffer _reason;

    public HttpEventListenerWrapper() {
        this._listener = null;
        this._delegatingRequests = false;
        this._delegatingResponses = false;
    }

    public HttpEventListenerWrapper(HttpEventListener eventListener, boolean delegating) {
        this._listener = eventListener;
        this._delegatingRequests = delegating;
        this._delegatingResponses = delegating;
    }

    public HttpEventListener getEventListener() {
        return this._listener;
    }

    public void setEventListener(HttpEventListener listener) {
        this._listener = listener;
    }

    public boolean isDelegatingRequests() {
        return this._delegatingRequests;
    }

    public boolean isDelegatingResponses() {
        return this._delegatingResponses;
    }

    public void setDelegatingRequests(boolean delegating) {
        this._delegatingRequests = delegating;
    }

    public void setDelegatingResponses(boolean delegating) {
        this._delegatingResponses = delegating;
    }

    public void setDelegationResult(boolean result) {
        this._delegationResult = result;
    }

    @Override
    public void onConnectionFailed(Throwable ex) {
        if (this._delegatingRequests) {
            this._listener.onConnectionFailed(ex);
        }
    }

    @Override
    public void onException(Throwable ex) {
        if (this._delegatingRequests || this._delegatingResponses) {
            this._listener.onException(ex);
        }
    }

    @Override
    public void onExpire() {
        if (this._delegatingRequests || this._delegatingResponses) {
            this._listener.onExpire();
        }
    }

    @Override
    public void onRequestCommitted() throws IOException {
        if (this._delegatingRequests) {
            this._listener.onRequestCommitted();
        }
    }

    @Override
    public void onRequestComplete() throws IOException {
        if (this._delegatingRequests) {
            this._listener.onRequestComplete();
        }
    }

    @Override
    public void onResponseComplete() throws IOException {
        if (this._delegatingResponses) {
            if (!this._delegationResult) {
                this._listener.onResponseStatus(this._version, this._status, this._reason);
            }
            this._listener.onResponseComplete();
        }
    }

    @Override
    public void onResponseContent(Buffer content) throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseContent(content);
        }
    }

    @Override
    public void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseHeader(name, value);
        }
    }

    @Override
    public void onResponseHeaderComplete() throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseHeaderComplete();
        }
    }

    @Override
    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (this._delegatingResponses) {
            this._listener.onResponseStatus(version, status, reason);
        } else {
            this._version = version;
            this._status = status;
            this._reason = reason;
        }
    }

    @Override
    public void onRetry() {
        if (this._delegatingRequests) {
            this._listener.onRetry();
        }
    }
}

