/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.8_1_13_v20130916.shade.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.jetty.8_1_13_v20130916.shade.client.CachedExchange;
import org.eclipse.jetty.8_1_13_v20130916.shade.http.HttpHeaders;
import org.eclipse.jetty.8_1_13_v20130916.shade.io.Buffer;
import org.eclipse.jetty.8_1_13_v20130916.shade.io.BufferUtil;
import org.eclipse.jetty.8_1_13_v20130916.shade.util.StringUtil;

public class ContentExchange
extends CachedExchange {
    private int _bufferSize = 4096;
    private String _encoding = "utf-8";
    private ByteArrayOutputStream _responseContent;
    private File _fileForUpload;

    public ContentExchange() {
        super(false);
    }

    public ContentExchange(boolean cacheFields) {
        super(cacheFields);
    }

    public synchronized String getResponseContent() throws UnsupportedEncodingException {
        if (this._responseContent != null) {
            return this._responseContent.toString(this._encoding);
        }
        return null;
    }

    public synchronized byte[] getResponseContentBytes() {
        if (this._responseContent != null) {
            return this._responseContent.toByteArray();
        }
        return null;
    }

    @Override
    protected synchronized void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        if (this._responseContent != null) {
            this._responseContent.reset();
        }
        super.onResponseStatus(version, status, reason);
    }

    @Override
    protected synchronized void onResponseHeader(Buffer name, Buffer value) throws IOException {
        super.onResponseHeader(name, value);
        int header = HttpHeaders.CACHE.getOrdinal(name);
        switch (header) {
            case 12: {
                this._bufferSize = BufferUtil.toInt(value);
                break;
            }
            case 16: {
                String mime = StringUtil.asciiToLowerCase(value.toString());
                int i = mime.indexOf("charset=");
                if (i <= 0) break;
                this._encoding = mime.substring(i + 8);
                i = this._encoding.indexOf(59);
                if (i <= 0) break;
                this._encoding = this._encoding.substring(0, i);
            }
        }
    }

    @Override
    protected synchronized void onResponseContent(Buffer content) throws IOException {
        super.onResponseContent(content);
        if (this._responseContent == null) {
            this._responseContent = new ByteArrayOutputStream(this._bufferSize);
        }
        content.writeTo(this._responseContent);
    }

    @Override
    protected synchronized void onRetry() throws IOException {
        if (this._fileForUpload != null) {
            this.setRequestContent(null);
            this.setRequestContentSource(this.getInputStream());
        } else {
            super.onRetry();
        }
    }

    private synchronized InputStream getInputStream() throws IOException {
        return new FileInputStream(this._fileForUpload);
    }

    public synchronized File getFileForUpload() {
        return this._fileForUpload;
    }

    public synchronized void setFileForUpload(File fileForUpload) throws IOException {
        this._fileForUpload = fileForUpload;
        this.setRequestContentSource(this.getInputStream());
    }
}

