/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.2_2.shade.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cometd.2_2.shade.bayeux.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTransport
implements Transport {
    private final String _name;
    private final Map<String, Object> _options;
    private String[] _prefix = new String[0];

    protected AbstractTransport(String name, Map<String, Object> options) {
        this._name = name;
        this._options = options == null ? new HashMap() : options;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Object getOption(String name) {
        Object value = this._options.get(name);
        String prefix = null;
        for (String segment : this._prefix) {
            String key = (prefix = prefix == null ? segment : prefix + "." + segment) + "." + name;
            if (!this._options.containsKey(key)) continue;
            value = this._options.get(key);
        }
        return value;
    }

    public void setOption(String name, Object value) {
        String prefix = this.getOptionPrefix();
        this._options.put(prefix == null ? name : prefix + "." + name, value);
    }

    @Override
    public String getOptionPrefix() {
        String prefix = null;
        for (String segment : this._prefix) {
            prefix = prefix == null ? segment : prefix + "." + segment;
        }
        return prefix;
    }

    public void setOptionPrefix(String prefix) {
        this._prefix = prefix.split("\\.");
    }

    @Override
    public Set<String> getOptionNames() {
        HashSet<String> names = new HashSet<String>();
        for (String name : this._options.keySet()) {
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0) {
                name = name.substring(lastDot + 1);
            }
            names.add(name);
        }
        return names;
    }

    public String getOption(String option, String dftValue) {
        Object value = this.getOption(option);
        return value == null ? dftValue : value.toString();
    }

    public long getOption(String option, long dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return dftValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public int getOption(String option, int dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return dftValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public boolean getOption(String option, boolean dftValue) {
        Object value = this.getOption(option);
        if (value == null) {
            return dftValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }
}

