/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.2_2.shade.common;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.cometd.2_2.shade.bayeux.ChannelId;
import org.cometd.2_2.shade.bayeux.Message;
import org.cometd.2_2.shade.bayeux.client.ClientSession;
import org.cometd.2_2.shade.bayeux.client.ClientSessionChannel;
import org.eclipse.jetty.8_1_13_v20130916.shade.util.AttributesMap;
import org.eclipse.jetty.8_1_13_v20130916.shade.util.log.Log;
import org.eclipse.jetty.8_1_13_v20130916.shade.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClientSession
implements ClientSession {
    private final List<ClientSession.Extension> _extensions = new CopyOnWriteArrayList<ClientSession.Extension>();
    private final AttributesMap _attributes = new AttributesMap();
    private final ConcurrentMap<String, AbstractSessionChannel> _channels = new ConcurrentHashMap<String, AbstractSessionChannel>();
    private final AtomicInteger _batch = new AtomicInteger();
    private final AtomicInteger _idGen = new AtomicInteger(0);

    protected AbstractClientSession() {
    }

    protected String newMessageId() {
        return String.valueOf(this._idGen.incrementAndGet());
    }

    @Override
    public void addExtension(ClientSession.Extension extension) {
        this._extensions.add(extension);
    }

    @Override
    public void removeExtension(ClientSession.Extension extension) {
        this._extensions.remove(extension);
    }

    protected boolean extendSend(Message.Mutable message) {
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.sendMeta(this, message)) continue;
                return false;
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.send(this, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean extendRcv(Message.Mutable message) {
        if (message.isMeta()) {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.rcvMeta(this, message)) continue;
                return false;
            }
        } else {
            for (ClientSession.Extension extension : this._extensions) {
                if (extension.rcv(this, message)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract ChannelId newChannelId(String var1);

    protected abstract AbstractSessionChannel newChannel(ChannelId var1);

    @Override
    public ClientSessionChannel getChannel(String channelId) {
        ChannelId id;
        AbstractSessionChannel new_channel;
        AbstractSessionChannel channel = (AbstractSessionChannel)this._channels.get(channelId);
        if (channel == null && (channel = this._channels.putIfAbsent(channelId, new_channel = this.newChannel(id = this.newChannelId(channelId)))) == null) {
            channel = new_channel;
        }
        return channel;
    }

    protected ConcurrentMap<String, AbstractSessionChannel> getChannels() {
        return this._channels;
    }

    @Override
    public void startBatch() {
        this._batch.incrementAndGet();
    }

    protected abstract void sendBatch();

    @Override
    public boolean endBatch() {
        if (this._batch.decrementAndGet() == 0) {
            this.sendBatch();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batch(Runnable batch) {
        this.startBatch();
        try {
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    protected boolean isBatching() {
        return this._batch.get() > 0;
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    @Override
    public Object removeAttribute(String name) {
        Object old = this._attributes.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    protected void resetSubscriptions() {
        for (AbstractSessionChannel ch : this._channels.values()) {
            ch.resetSubscriptions();
        }
    }

    public void receive(Message.Mutable message) {
        String id = message.getChannel();
        if (id == null) {
            throw new IllegalArgumentException("Bayeux messages must have a channel, " + message);
        }
        if (!this.extendRcv(message)) {
            return;
        }
        AbstractSessionChannel channel = (AbstractSessionChannel)this.getChannel(id);
        ChannelId channelId = channel.getChannelId();
        channel.notifyMessageListeners(message);
        for (String channelPattern : channelId.getWilds()) {
            ChannelId channelIdPattern = this.newChannelId(channelPattern);
            if (!channelIdPattern.matches(channelId)) continue;
            AbstractSessionChannel wildChannel = (AbstractSessionChannel)this.getChannel(channelPattern);
            wildChannel.notifyMessageListeners(message);
        }
    }

    public void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append('\n');
        int leaves = this._channels.size();
        int i = 0;
        for (AbstractSessionChannel child : this._channels.values()) {
            b.append(indent);
            b.append(" +-");
            child.dump(b, indent + (++i == leaves ? "   " : " | "));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractSessionChannel
    implements ClientSessionChannel {
        protected final Logger logger = Log.getLogger(this.getClass().getName());
        private final ChannelId _id;
        private final AttributesMap _attributes = new AttributesMap();
        private final CopyOnWriteArrayList<ClientSessionChannel.MessageListener> _subscriptions = new CopyOnWriteArrayList();
        private final AtomicInteger _subscriptionCount = new AtomicInteger();
        private final CopyOnWriteArrayList<ClientSessionChannel.ClientSessionChannelListener> _listeners = new CopyOnWriteArrayList();

        protected AbstractSessionChannel(ChannelId id) {
            this._id = id;
        }

        @Override
        public ChannelId getChannelId() {
            return this._id;
        }

        @Override
        public void addListener(ClientSessionChannel.ClientSessionChannelListener listener) {
            this._listeners.add(listener);
        }

        @Override
        public void removeListener(ClientSessionChannel.ClientSessionChannelListener listener) {
            this._listeners.remove(listener);
        }

        protected abstract void sendSubscribe();

        protected abstract void sendUnSubscribe();

        @Override
        public void subscribe(ClientSessionChannel.MessageListener listener) {
            int count;
            boolean added = this._subscriptions.add(listener);
            if (added && (count = this._subscriptionCount.incrementAndGet()) == 1) {
                this.sendSubscribe();
            }
        }

        @Override
        public void unsubscribe(ClientSessionChannel.MessageListener listener) {
            int count;
            boolean removed = this._subscriptions.remove(listener);
            if (removed && (count = this._subscriptionCount.decrementAndGet()) == 0) {
                this.sendUnSubscribe();
            }
        }

        @Override
        public void unsubscribe() {
            for (ClientSessionChannel.MessageListener listener : this._subscriptions) {
                this.unsubscribe(listener);
            }
        }

        protected void resetSubscriptions() {
            for (ClientSessionChannel.MessageListener l : this._subscriptions) {
                if (!this._subscriptions.remove(l)) continue;
                this._subscriptionCount.decrementAndGet();
            }
        }

        @Override
        public String getId() {
            return this._id.toString();
        }

        @Override
        public boolean isDeepWild() {
            return this._id.isDeepWild();
        }

        @Override
        public boolean isMeta() {
            return this._id.isMeta();
        }

        @Override
        public boolean isService() {
            return this._id.isService();
        }

        @Override
        public boolean isWild() {
            return this._id.isWild();
        }

        protected void notifyMessageListeners(Message message) {
            for (ClientSessionChannel.ClientSessionChannelListener clientSessionChannelListener : this._listeners) {
                if (!(clientSessionChannelListener instanceof ClientSessionChannel.MessageListener)) continue;
                try {
                    ((ClientSessionChannel.MessageListener)clientSessionChannelListener).onMessage(this, message);
                }
                catch (Exception x) {
                    this.logger.info(x);
                }
            }
            for (ClientSessionChannel.MessageListener messageListener : this._subscriptions) {
                if (!(messageListener instanceof ClientSessionChannel.MessageListener) || message.getData() == null) continue;
                try {
                    messageListener.onMessage(this, message);
                }
                catch (Exception x) {
                    this.logger.info(x);
                }
            }
        }

        @Override
        public void setAttribute(String name, Object value) {
            this._attributes.setAttribute(name, value);
        }

        @Override
        public Object getAttribute(String name) {
            return this._attributes.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNames() {
            return this._attributes.keySet();
        }

        @Override
        public Object removeAttribute(String name) {
            Object old = this.getAttribute(name);
            this._attributes.removeAttribute(name);
            return old;
        }

        protected void dump(StringBuilder b, String indent) {
            b.append(this.toString());
            b.append('\n');
            for (ClientSessionChannel.ClientSessionChannelListener clientSessionChannelListener : this._listeners) {
                b.append(indent);
                b.append(" +-");
                b.append(clientSessionChannelListener);
                b.append('\n');
            }
            for (ClientSessionChannel.MessageListener messageListener : this._subscriptions) {
                b.append(indent);
                b.append(" +-");
                b.append(messageListener);
                b.append('\n');
            }
        }

        public String toString() {
            return this._id.toString();
        }
    }
}

