/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.2_2.shade.client.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cometd.2_2.shade.client.transport.ClientTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportRegistry {
    private final Map<String, ClientTransport> _transports = new HashMap<String, ClientTransport>();
    private final List<String> _allowed = new ArrayList<String>();

    public void add(ClientTransport transport) {
        if (transport != null) {
            this._transports.put(transport.getName(), transport);
            this._allowed.add(transport.getName());
        }
    }

    public Set<String> getKnownTransports() {
        return Collections.unmodifiableSet(this._transports.keySet());
    }

    public List<String> getAllowedTransports() {
        return Collections.unmodifiableList(this._allowed);
    }

    public List<ClientTransport> negotiate(Object[] requestedTransports, String bayeuxVersion) {
        ArrayList<ClientTransport> list = new ArrayList<ClientTransport>();
        for (String transportName : this._allowed) {
            for (Object requestedTransportName : requestedTransports) {
                ClientTransport transport;
                if (!requestedTransportName.equals(transportName) || !(transport = this.getTransport(transportName)).accept(bayeuxVersion)) continue;
                list.add(transport);
            }
        }
        return list;
    }

    public ClientTransport getTransport(String transport) {
        return this._transports.get(transport);
    }
}

