/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.2_2.shade.client.transport;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cometd.2_2.shade.bayeux.Message;
import org.cometd.2_2.shade.client.transport.HttpClientTransport;
import org.cometd.2_2.shade.client.transport.TransportListener;
import org.eclipse.jetty.8_1_13_v20130916.shade.client.ContentExchange;
import org.eclipse.jetty.8_1_13_v20130916.shade.client.HttpClient;
import org.eclipse.jetty.8_1_13_v20130916.shade.client.HttpExchange;
import org.eclipse.jetty.8_1_13_v20130916.shade.http.HttpHeaders;
import org.eclipse.jetty.8_1_13_v20130916.shade.io.Buffer;
import org.eclipse.jetty.8_1_13_v20130916.shade.io.ByteArrayBuffer;
import org.eclipse.jetty.8_1_13_v20130916.shade.util.QuotedStringTokenizer;
import org.eclipse.jetty.8_1_13_v20130916.shade.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongPollingTransport
extends HttpClientTransport {
    private final HttpClient _httpClient;
    private final List<HttpExchange> _exchanges = new ArrayList<HttpExchange>();
    private volatile boolean _aborted;
    private volatile boolean _appendMessageType;
    private volatile Map<String, Object> _advice;

    public static LongPollingTransport create(Map<String, Object> options) {
        HttpClient httpClient = new HttpClient();
        httpClient.setIdleTimeout(5000L);
        httpClient.setConnectorType(2);
        httpClient.setMaxConnectionsPerAddress(32768);
        return LongPollingTransport.create(options, httpClient);
    }

    public static LongPollingTransport create(Map<String, Object> options, HttpClient httpClient) {
        LongPollingTransport transport = new LongPollingTransport(options, httpClient);
        if (!httpClient.isStarted()) {
            try {
                httpClient.start();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return transport;
    }

    public LongPollingTransport(Map<String, Object> options, HttpClient httpClient) {
        super("long-polling", options);
        this._httpClient = httpClient;
        this.setOptionPrefix("long-polling.json");
    }

    @Override
    public boolean accept(String bayeuxVersion) {
        return true;
    }

    @Override
    public void init() {
        super.init();
        this._aborted = false;
        Pattern uriRegexp = Pattern.compile("(^https?://(([^:/\\?#]+)(:(\\d+))?))?([^\\?#]*)(.*)?");
        Matcher uriMatcher = uriRegexp.matcher(this.getURL());
        if (uriMatcher.matches()) {
            String afterPath = uriMatcher.group(7);
            this._appendMessageType = afterPath == null || afterPath.trim().length() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        LongPollingTransport longPollingTransport = this;
        synchronized (longPollingTransport) {
            this._aborted = true;
            for (HttpExchange exchange : this._exchanges) {
                exchange.cancel();
            }
        }
    }

    @Override
    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(TransportListener listener, Message.Mutable ... messages) {
        TransportExchange httpExchange = new TransportExchange(listener, (Message[])messages);
        httpExchange.setMethod("POST");
        String url = this.getURL();
        httpExchange.setURL(url);
        if (this._appendMessageType && messages.length == 1 && messages[0].isMeta()) {
            String type = messages[0].getChannel().substring("/meta".length());
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url + type;
            httpExchange.setURL(url);
        }
        String content = JSON.toString(messages);
        httpExchange.setRequestContentType("application/json;charset=UTF-8");
        try {
            httpExchange.setRequestContent(new ByteArrayBuffer(content, "UTF-8"));
            this.customize(httpExchange);
            LongPollingTransport longPollingTransport = this;
            synchronized (longPollingTransport) {
                if (this._aborted) {
                    throw new IllegalStateException("Aborted");
                }
                this._exchanges.add(httpExchange);
            }
            long maxNetworkDelay = this.getOption("maxNetworkDelay", this._httpClient.getTimeout());
            if (messages.length == 1 && "/meta/connect".equals(messages[0].getChannel())) {
                Map<String, Object> advice = messages[0].getAdvice();
                if (advice == null) {
                    advice = this._advice;
                }
                if (advice != null) {
                    Object timeout = advice.get("timeout");
                    if (timeout instanceof Number) {
                        maxNetworkDelay += ((Number)timeout).longValue();
                    } else if (timeout != null) {
                        maxNetworkDelay += Long.parseLong(timeout.toString());
                    }
                }
            }
            httpExchange.setTimeout(maxNetworkDelay);
            this._httpClient.send(httpExchange);
        }
        catch (Exception x) {
            listener.onException(x, messages);
        }
    }

    protected void customize(ContentExchange exchange) {
        HttpClientTransport.CookieProvider cookieProvider = this.getCookieProvider();
        if (cookieProvider != null) {
            StringBuilder builder = new StringBuilder();
            for (HttpClientTransport.Cookie cookie : cookieProvider.getCookies()) {
                if (builder.length() > 0) {
                    builder.append("; ");
                }
                builder.append(cookie.asString());
            }
            if (builder.length() > 0) {
                exchange.setRequestHeader("Cookie", builder.toString());
            }
        }
    }

    private class TransportExchange
    extends ContentExchange {
        private final TransportListener _listener;
        private final Message[] _messages;

        private TransportExchange(TransportListener listener, Message ... messages) {
            super(true);
            this._listener = listener;
            this._messages = messages;
        }

        protected void onRequestCommitted() throws IOException {
            this._listener.onSending(this._messages);
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            super.onResponseHeader(name, value);
            int headerName = HttpHeaders.CACHE.getOrdinal(name);
            if (headerName == 53) {
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(value.toString(), "=;", false, false);
                tokenizer.setSingle(false);
                String cookieName = null;
                if (tokenizer.hasMoreTokens()) {
                    cookieName = tokenizer.nextToken();
                }
                String cookieValue = null;
                if (tokenizer.hasMoreTokens()) {
                    cookieValue = tokenizer.nextToken();
                }
                if (cookieName != null && cookieValue != null) {
                    int version = 0;
                    String comment = null;
                    String path = null;
                    String domain = null;
                    int maxAge = -1;
                    boolean secure = false;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if ("Version".equalsIgnoreCase(token)) {
                            version = Integer.parseInt(tokenizer.nextToken());
                            continue;
                        }
                        if ("Comment".equalsIgnoreCase(token)) {
                            comment = tokenizer.nextToken();
                            continue;
                        }
                        if ("Path".equalsIgnoreCase(token)) {
                            path = tokenizer.nextToken();
                            continue;
                        }
                        if ("Domain".equalsIgnoreCase(token)) {
                            domain = tokenizer.nextToken();
                            continue;
                        }
                        if ("Expires".equalsIgnoreCase(token)) {
                            try {
                                Date date = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss 'GMT'").parse(tokenizer.nextToken());
                                Long maxAgeValue = TimeUnit.MILLISECONDS.toSeconds(date.getTime() - System.currentTimeMillis());
                                maxAge = maxAgeValue > 0L ? maxAgeValue.intValue() : 0;
                            }
                            catch (ParseException ignored) {}
                            continue;
                        }
                        if ("Max-Age".equalsIgnoreCase(token)) {
                            try {
                                maxAge = Integer.parseInt(tokenizer.nextToken());
                            }
                            catch (NumberFormatException ignored) {}
                            continue;
                        }
                        if (!"Secure".equalsIgnoreCase(token)) continue;
                        secure = true;
                    }
                    HttpClientTransport.Cookie cookie = new HttpClientTransport.Cookie(cookieName, cookieValue, domain, path, maxAge, secure, version, comment);
                    LongPollingTransport.this.setCookie(cookie);
                }
            }
        }

        protected void onResponseComplete() throws IOException {
            this.complete();
            if (this.getResponseStatus() == 200) {
                String content = this.getResponseContent();
                if (content != null && content.length() > 0) {
                    List<Message.Mutable> messages = LongPollingTransport.this.parseMessages(this.getResponseContent());
                    for (Message.Mutable message : messages) {
                        Map<String, Object> advice;
                        if (!message.isSuccessful() || !"/meta/connect".equals(message.getChannel()) || (advice = message.getAdvice()) == null || advice.get("timeout") == null) continue;
                        LongPollingTransport.this._advice = advice;
                    }
                    this._listener.onMessages(messages);
                } else {
                    this._listener.onProtocolError("Empty response: " + this, this._messages);
                }
            } else {
                this._listener.onProtocolError("Unexpected response " + this.getResponseStatus() + ": " + this, this._messages);
            }
        }

        protected void onConnectionFailed(Throwable x) {
            this.complete();
            this._listener.onConnectException(x, this._messages);
        }

        protected void onException(Throwable x) {
            this.complete();
            this._listener.onException(x, this._messages);
        }

        protected void onExpire() {
            this.complete();
            this._listener.onExpire(this._messages);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete() {
            LongPollingTransport longPollingTransport = LongPollingTransport.this;
            synchronized (longPollingTransport) {
                LongPollingTransport.this._exchanges.remove(this);
            }
        }
    }
}

