/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.2_2.shade.bayeux;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelId {
    public static final String WILD = "*";
    public static final String DEEPWILD = "**";
    private final String _name;
    private final String[] _segments;
    private final int _wild;
    private final List<String> _wilds;
    private final String _parent;

    public ChannelId(String name) {
        this._name = name;
        if (name == null || name.length() == 0 || name.charAt(0) != '/' || "/".equals(name)) {
            throw new IllegalArgumentException(name);
        }
        if (name.charAt(name.length() - 1) == '/') {
            name = name.substring(0, name.length() - 1);
        }
        this._segments = name.substring(1).split("/");
        String[] wilds = new String[this._segments.length + 1];
        StringBuilder b = new StringBuilder();
        b.append('/');
        for (int i = 0; i < this._segments.length; ++i) {
            if (this._segments[i] == null || this._segments[i].length() == 0) {
                throw new IllegalArgumentException(name);
            }
            if (i > 0) {
                b.append(this._segments[i - 1]).append('/');
            }
            wilds[this._segments.length - i] = b + DEEPWILD;
        }
        wilds[0] = b + WILD;
        String string = this._parent = this._segments.length == 1 ? null : b.substring(0, b.length() - 1);
        this._wild = this._segments.length == 0 ? 0 : (WILD.equals(this._segments[this._segments.length - 1]) ? 1 : (DEEPWILD.equals(this._segments[this._segments.length - 1]) ? 2 : 0));
        this._wilds = this._wild == 0 ? Collections.unmodifiableList(Arrays.asList(wilds)) : Collections.emptyList();
    }

    public boolean isWild() {
        return this._wild > 0;
    }

    public boolean isDeepWild() {
        return this._wild > 1;
    }

    public boolean isMeta() {
        return this._segments.length > 0 && "meta".equals(this._segments[0]);
    }

    public boolean isService() {
        return this._segments.length > 0 && "service".equals(this._segments[0]);
    }

    public boolean equals(Object obj) {
        ChannelId id;
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChannelId && (id = (ChannelId)obj).depth() == this.depth()) {
            int i = id.depth();
            while (i-- > 0) {
                if (id.getSegment(i).equals(this.getSegment(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(ChannelId name) {
        if (name.isWild()) {
            return this.equals(name);
        }
        switch (this._wild) {
            case 0: {
                return this.equals(name);
            }
            case 1: {
                if (name._segments.length != this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(name._segments[i])) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                if (name._segments.length < this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(name._segments[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }

    public int depth() {
        return this._segments.length;
    }

    public boolean isAncestorOf(ChannelId id) {
        if (this.isWild() || this.depth() >= id.depth()) {
            return false;
        }
        int i = this._segments.length;
        while (i-- > 0) {
            if (this._segments[i].equals(id._segments[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isParentOf(ChannelId id) {
        if (this.isWild() || this.depth() != id.depth() - 1) {
            return false;
        }
        int i = this._segments.length;
        while (i-- > 0) {
            if (this._segments[i].equals(id._segments[i])) continue;
            return false;
        }
        return true;
    }

    public String getParent() {
        return this._parent;
    }

    public String getSegment(int i) {
        if (i > this._segments.length) {
            return null;
        }
        return this._segments[i];
    }

    public List<String> getWilds() {
        return this._wilds;
    }

    public static boolean isMeta(String channelId) {
        return channelId != null && channelId.startsWith("/meta/");
    }

    public static boolean isService(String channelId) {
        return channelId != null && channelId.startsWith("/service/");
    }
}

