/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.scripting.component;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.DefaultMuleEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.registry.Registry;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.el.context.FlowVariableMapContext;
import org.mule.runtime.core.el.context.SessionVariableMapContext;
import org.mule.runtime.core.util.CollectionUtils;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.scripting.component.RegistryLookupBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scriptable
implements Initialisable,
MuleContextAware,
FlowConstructAware {
    private static final String BINDING_LOG = "log";
    private static final String BINDING_RESULT = "result";
    private static final String BINDING_MULE_CONTEXT = "muleContext";
    private static final String BINDING_REGISTRY = "registry";
    private static final String BINDING_PAYLOAD = "payload";
    private static final String BINDING_SRC = "src";
    private static final String BINDING_EVENT_CONTEXT = "eventContext";
    private static final String BINDING_ID = "id";
    private static final String BINDING_FLOW_CONSTRUCT = "flowConstruct";
    private static final String BINDING_FLOW_VARS = "flowVars";
    private static final String BINDING_SESSION_VARS = "sessionVars";
    private static final String BINDING_EXCEPTION = "exception";
    public static final String BINDING_MESSAGE = "message";
    private String scriptText;
    private String scriptFile;
    private Properties properties;
    private String scriptEngineName;
    private CompiledScript compiledScript;
    private ScriptEngine scriptEngine;
    private ScriptEngineManager scriptEngineManager;
    private MuleContext muleContext;
    private FlowConstruct flow;
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public Scriptable() {
    }

    public Scriptable(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flow = flowConstruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() throws InitialisationException {
        block22: {
            int i;
            this.scriptEngineManager = new ScriptEngineManager();
            if (this.scriptEngineName != null) {
                this.scriptEngine = this.createScriptEngineByName(this.scriptEngineName);
                if (this.scriptEngine == null) {
                    throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Scripting engine '" + this.scriptEngineName + "' not found.  Available engines are: " + this.listAvailableEngines())), (Initialisable)this);
                }
            } else if (this.scriptFile != null && (i = this.scriptFile.lastIndexOf(".")) > -1) {
                this.logger.info("Script Engine name not set. Guessing by file extension.");
                String extension = this.scriptFile.substring(i + 1);
                this.scriptEngine = this.createScriptEngineByExtension(extension);
                if (this.scriptEngine == null) {
                    throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("File extension '" + extension + "' does not map to a scripting engine.  Available engines are: " + this.listAvailableEngines())), (Initialisable)this);
                }
                this.setScriptEngineName(extension);
            }
            Reader script = null;
            try {
                if (StringUtils.isNotBlank((String)this.scriptText)) {
                    script = new StringReader(this.scriptText);
                } else if (this.scriptFile != null) {
                    InputStream is;
                    try {
                        is = IOUtils.getResourceAsStream((String)this.scriptFile, this.getClass());
                    }
                    catch (IOException e) {
                        throw new InitialisationException(CoreMessages.cannotLoadFromClasspath((String)this.scriptFile), (Throwable)e, (Initialisable)this);
                    }
                    if (is == null) {
                        throw new InitialisationException(CoreMessages.cannotLoadFromClasspath((String)this.scriptFile), (Initialisable)this);
                    }
                    script = new InputStreamReader(is);
                } else {
                    throw new InitialisationException(CoreMessages.propertiesNotSet((String)"scriptText, scriptFile"), (Initialisable)this);
                }
                if (!(this.scriptEngine instanceof Compilable)) break block22;
                try {
                    this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(script);
                }
                catch (ScriptException e) {
                    throw new InitialisationException((Throwable)e, (Initialisable)this);
                }
            }
            finally {
                if (script != null) {
                    try {
                        script.close();
                    }
                    catch (IOException e) {
                        throw new InitialisationException((Throwable)e, (Initialisable)this);
                    }
                }
            }
        }
    }

    protected void populatePropertyBindings(Bindings bindings) {
        if (this.properties != null) {
            bindings.putAll(this.properties);
        }
    }

    protected void populatePropertyBindings(Bindings bindings, Event event) {
        if (this.properties != null) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String value = (String)entry.getValue();
                if (this.muleContext.getExpressionManager().isExpression(value)) {
                    bindings.put((String)entry.getKey(), (Object)this.muleContext.getExpressionManager().parse(value, event, this.flow));
                    continue;
                }
                bindings.put((String)entry.getKey(), (Object)value);
            }
        }
    }

    public void populateDefaultBindings(Bindings bindings) {
        bindings.put(BINDING_LOG, (Object)this.logger);
        bindings.put(BINDING_RESULT, (Object)null);
        bindings.put(BINDING_MULE_CONTEXT, (Object)this.muleContext);
        bindings.put(BINDING_REGISTRY, (Object)this.muleContext.getRegistry());
    }

    public void populateBindings(Bindings bindings, Event event, Event.Builder eventBuilder) {
        this.populatePropertyBindings(bindings, event);
        this.populateDefaultBindings(bindings);
        this.populateMessageBindings(bindings, event, eventBuilder);
        bindings.put(BINDING_EVENT_CONTEXT, (Object)new DefaultMuleEventContext(this.flow, event));
        bindings.put(BINDING_FLOW_CONSTRUCT, (Object)this.flow);
    }

    protected void populateMessageBindings(Bindings bindings, Event event, Event.Builder eventBuilder) {
        InternalMessage message = event.getMessage();
        this.populateVariablesInOrder(bindings, event);
        bindings.put(BINDING_MESSAGE, (Object)event.getMessage());
        bindings.put(BINDING_PAYLOAD, message.getPayload().getValue());
        bindings.put(BINDING_SRC, message.getPayload().getValue());
        this.populateHeadersVariablesAndException(bindings, event, eventBuilder);
    }

    private void populateHeadersVariablesAndException(Bindings bindings, Event event, Event.Builder eventBuilder) {
        bindings.put(BINDING_FLOW_VARS, (Object)new FlowVariableMapContext(event, eventBuilder));
        bindings.put(BINDING_SESSION_VARS, (Object)new SessionVariableMapContext(event.getSession()));
        if (event.getError().isPresent()) {
            bindings.put(BINDING_EXCEPTION, (Object)((Error)event.getError().get()).getCause());
        } else {
            bindings.put(BINDING_EXCEPTION, (Object)null);
        }
    }

    private void populateVariablesInOrder(Bindings bindings, Event event) {
        for (String key : event.getSession().getPropertyNamesAsSet()) {
            bindings.put(key, event.getSession().getProperty(key));
        }
        for (String key : event.getVariableNames()) {
            bindings.put(key, event.getVariable(key).getValue());
        }
    }

    public Object runScript(Bindings bindings) throws ScriptException {
        Object result;
        try {
            RegistryLookupBindings registryLookupBindings = new RegistryLookupBindings((Registry)this.muleContext.getRegistry(), bindings);
            result = this.compiledScript != null ? this.compiledScript.eval(registryLookupBindings) : this.scriptEngine.eval(this.scriptText, (Bindings)registryLookupBindings);
            if (result == null) {
                result = registryLookupBindings.get(BINDING_RESULT);
            }
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ScriptException(ex);
        }
        return result;
    }

    protected ScriptEngine createScriptEngineByName(String name) {
        return this.scriptEngineManager.getEngineByName(name);
    }

    protected ScriptEngine createScriptEngineByExtension(String ext) {
        return this.scriptEngineManager.getEngineByExtension(ext);
    }

    protected String listAvailableEngines() {
        return CollectionUtils.toString(this.scriptEngineManager.getEngineFactories(), (boolean)false);
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    protected void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    protected CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    protected void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }
}

