/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.component;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEventContext;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.Registry;
import org.mule.api.service.Service;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.scripting.component.RegistryLookupBindings;
import org.mule.transport.NullPayload;
import org.mule.util.CollectionUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class Scriptable
implements Initialisable,
MuleContextAware {
    private String scriptText;
    private String scriptFile;
    private Properties properties;
    private String scriptEngineName;
    private CompiledScript compiledScript;
    private ScriptEngine scriptEngine;
    private ScriptEngineManager scriptEngineManager;
    private MuleContext muleContext;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public Scriptable() {
    }

    public Scriptable(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() throws InitialisationException {
        block22: {
            int i;
            this.scriptEngineManager = new ScriptEngineManager();
            if (this.scriptEngineName != null) {
                this.scriptEngine = this.createScriptEngineByName(this.scriptEngineName);
                if (this.scriptEngine == null) {
                    throw new InitialisationException(MessageFactory.createStaticMessage((String)("Scripting engine '" + this.scriptEngineName + "' not found.  Available engines are: " + this.listAvailableEngines())), (Initialisable)this);
                }
            } else if (this.scriptFile != null && (i = this.scriptFile.lastIndexOf(".")) > -1) {
                this.logger.info((Object)"Script Engine name not set. Guessing by file extension.");
                String ext = this.scriptFile.substring(i + 1);
                this.scriptEngine = this.createScriptEngineByExtension(ext);
                if (this.scriptEngine == null) {
                    throw new InitialisationException(MessageFactory.createStaticMessage((String)("File extension '" + ext + "' does not map to a scripting engine.  Available engines are: " + this.listAvailableEngines())), (Initialisable)this);
                }
                this.setScriptEngineName(this.scriptEngine.getFactory().getEngineName());
            }
            Reader script = null;
            try {
                if (StringUtils.isNotBlank((String)this.scriptText)) {
                    script = new StringReader(this.scriptText);
                } else if (this.scriptFile != null) {
                    InputStream is;
                    try {
                        is = IOUtils.getResourceAsStream((String)this.scriptFile, this.getClass());
                    }
                    catch (IOException e) {
                        throw new InitialisationException(CoreMessages.cannotLoadFromClasspath((String)this.scriptFile), (Throwable)e, (Initialisable)this);
                    }
                    if (is == null) {
                        throw new InitialisationException(CoreMessages.cannotLoadFromClasspath((String)this.scriptFile), (Initialisable)this);
                    }
                    script = new InputStreamReader(is);
                } else {
                    throw new InitialisationException(CoreMessages.propertiesNotSet((String)"scriptText, scriptFile"), (Initialisable)this);
                }
                if (!(this.scriptEngine instanceof Compilable)) break block22;
                try {
                    this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(script);
                }
                catch (ScriptException e) {
                    throw new InitialisationException((Throwable)e, (Initialisable)this);
                }
            }
            finally {
                if (script != null) {
                    try {
                        script.close();
                    }
                    catch (IOException e) {
                        throw new InitialisationException((Throwable)e, (Initialisable)this);
                    }
                }
            }
        }
    }

    public void populateDefaultBindings(Bindings bindings) {
        if (this.properties != null) {
            bindings.putAll(this.properties);
        }
        bindings.put("log", (Object)this.logger);
        bindings.put("result", (Object)NullPayload.getInstance());
        bindings.put("muleContext", (Object)this.muleContext);
        bindings.put("registry", (Object)this.muleContext.getRegistry());
    }

    public void populateBindings(Bindings bindings, Object payload) {
        this.populateDefaultBindings(bindings);
        bindings.put("payload", payload);
        bindings.put("src", payload);
    }

    public void populateBindings(Bindings bindings, MuleMessage message) {
        this.populateDefaultBindings(bindings);
        if (message == null) {
            message = new DefaultMuleMessage((Object)NullPayload.getInstance(), this.muleContext);
        }
        this.populateVariablesInOrder(bindings, message);
        bindings.put("message", (Object)message);
        bindings.put("payload", message.getPayload());
        bindings.put("src", message.getPayload());
        this.populateHeadersVariablesAndException(bindings, message);
    }

    public void populateBindings(Bindings bindings, MuleEvent event) {
        this.populateBindings(bindings, event.getMessage());
        bindings.put("originalPayload", event.getMessage().getPayload());
        bindings.put("payload", event.getMessage().getPayload());
        bindings.put("eventContext", (Object)new DefaultMuleEventContext(event));
        bindings.put("id", (Object)event.getId());
        bindings.put("flowConstruct", (Object)event.getFlowConstruct());
        if (event.getFlowConstruct() instanceof Service) {
            bindings.put("service", (Object)event.getFlowConstruct());
        }
    }

    private void populateHeadersVariablesAndException(Bindings bindings, MuleMessage message) {
        bindings.put("flowVars", (Object)new MesssagePropertyMap(message, PropertyScope.INVOCATION));
        bindings.put("sessionVars", (Object)new MesssagePropertyMap(message, PropertyScope.SESSION));
        if (message.getExceptionPayload() != null) {
            bindings.put("exception", (Object)message.getExceptionPayload().getException());
        } else {
            bindings.put("exception", (Object)null);
        }
    }

    private void populateVariablesInOrder(Bindings bindings, MuleMessage message) {
        for (String key : message.getSessionPropertyNames()) {
            bindings.put(key, message.getSessionProperty(key));
        }
        for (String key : message.getInvocationPropertyNames()) {
            bindings.put(key, message.getInvocationProperty(key));
        }
    }

    public Object runScript(Bindings bindings) throws ScriptException {
        Object result;
        try {
            RegistryLookupBindings registryLookupBindings = new RegistryLookupBindings((Registry)this.muleContext.getRegistry(), bindings);
            result = this.compiledScript != null ? this.compiledScript.eval(registryLookupBindings) : this.scriptEngine.eval(this.scriptText, (Bindings)registryLookupBindings);
            if (result == null) {
                result = registryLookupBindings.get("result");
            }
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ScriptException(ex);
        }
        return result;
    }

    protected ScriptEngine createScriptEngineByName(String name) {
        return this.scriptEngineManager.getEngineByName(name);
    }

    protected ScriptEngine createScriptEngineByExtension(String ext) {
        return this.scriptEngineManager.getEngineByExtension(ext);
    }

    protected String listAvailableEngines() {
        return CollectionUtils.toString(this.scriptEngineManager.getEngineFactories(), (boolean)false);
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    protected void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    protected CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    protected void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    private static class MesssagePropertyMap
    implements Map<String, Object> {
        MuleMessage message;
        PropertyScope propertyScope;

        public MesssagePropertyMap(MuleMessage message, PropertyScope propertyScope) {
            this.message = message;
            this.propertyScope = propertyScope;
        }

        @Override
        public void clear() {
            this.message.clearProperties(this.propertyScope);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.message.getPropertyNames(this.propertyScope).contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return this.message.getProperty((String)key, this.propertyScope);
        }

        @Override
        public boolean isEmpty() {
            return this.message.getPropertyNames(this.propertyScope).isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.message.getPropertyNames(this.propertyScope);
        }

        @Override
        public Object put(String key, Object value) {
            if (PropertyScope.INBOUND.equals((Object)this.propertyScope)) {
                throw new UnsupportedOperationException("Inbound message properties are read-only");
            }
            this.message.setProperty(key, value, this.propertyScope);
            return value;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            if (PropertyScope.INBOUND.equals((Object)this.propertyScope)) {
                throw new UnsupportedOperationException("Inbound message properties are read-only");
            }
            return this.message.removeProperty((String)key, this.propertyScope);
        }

        @Override
        public int size() {
            return this.message.getPropertyNames(this.propertyScope).size();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }
    }
}

