/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.BindingCollection;
import org.mule.api.routing.InterfaceBinding;
import org.mule.component.AbstractComponent;
import org.mule.module.scripting.component.Scriptable;
import org.mule.routing.binding.BindingInvocationHandler;
import org.mule.routing.binding.DefaultBindingCollection;
import org.mule.util.ClassUtils;

public class ScriptComponent
extends AbstractComponent {
    protected BindingCollection bindingCollection = new DefaultBindingCollection();
    private Scriptable script;
    private Map proxies;

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        try {
            this.configureComponentBindings();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected Object doInvoke(MuleEvent event) throws Exception {
        Bindings bindings = this.script.getScriptEngine().createBindings();
        if (this.proxies.size() > 0) {
            bindings.putAll(this.proxies);
        }
        this.script.populateBindings(bindings, event);
        return this.script.runScript(bindings);
    }

    public Scriptable getScript() {
        return this.script;
    }

    public void setScript(Scriptable script) {
        this.script = script;
    }

    public BindingCollection getBindingCollection() {
        return this.bindingCollection;
    }

    public void setBindingCollection(BindingCollection bindingCollection) {
        this.bindingCollection = bindingCollection;
    }

    protected void configureComponentBindings() throws MuleException {
        this.proxies = new HashMap();
        if (this.bindingCollection != null && this.bindingCollection.getRouters().size() > 0) {
            for (InterfaceBinding interfaceBinding : this.bindingCollection.getRouters()) {
                Object proxy;
                String bindingName = ClassUtils.getSimpleName((Class)interfaceBinding.getInterface());
                if (this.proxies.containsKey(bindingName)) {
                    proxy = this.proxies.get(bindingName);
                    BindingInvocationHandler handler = (BindingInvocationHandler)Proxy.getInvocationHandler(proxy);
                    handler.addRouterForInterface(interfaceBinding);
                    continue;
                }
                proxy = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{interfaceBinding.getInterface()}, (InvocationHandler)new BindingInvocationHandler(interfaceBinding));
                this.proxies.put(bindingName, proxy);
            }
        }
    }
}

