/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import org.mule.MuleServer;
import org.mule.RegistryContext;
import org.mule.components.script.jsr223.Scriptable;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.builders.i18n.BuildersMessages;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.registry.RegistrationException;
import org.mule.registry.Registry;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;

public class ScriptConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    public static final String SCRIPT_ENGINE_NAME_PROPERTY = "org.mule.script.engine";
    private Scriptable scriptComponent = new Scriptable();
    protected UMOManagementContext managementContext = null;
    protected boolean initialised = false;

    public ScriptConfigurationBuilder() throws UMOException {
        String scriptName = System.getProperty(SCRIPT_ENGINE_NAME_PROPERTY);
        if (scriptName == null) {
            throw new IllegalArgumentException(BuildersMessages.systemPropertyNotSet((String)SCRIPT_ENGINE_NAME_PROPERTY).getMessage());
        }
        this.scriptComponent.setScriptEngineName(scriptName);
    }

    public ScriptConfigurationBuilder(String scriptEngineName) throws UMOException {
        this(scriptEngineName, true);
    }

    public ScriptConfigurationBuilder(String scriptEngineName, boolean createDefaultRegistry) throws UMOException {
        this.scriptComponent.setScriptEngineName(scriptEngineName);
    }

    public UMOManagementContext configure(String[] configResources, Properties startupProperties) throws ConfigurationException {
        try {
            MuleApplicationContext context = new MuleApplicationContext(new String[]{this.getDefaultConfigResource()});
            this.managementContext = context.getManagementContext();
            MuleServer.setManagementContext((UMOManagementContext)this.managementContext);
            Registry registry = RegistryContext.getOrCreateRegistry();
            try {
                registry.registerObjects((Map)startupProperties);
            }
            catch (RegistrationException e) {
                throw new ConfigurationException((Throwable)e);
            }
            for (int i = 0; i < configResources.length; ++i) {
                String configResource = configResources[i];
                this.scriptComponent.setScriptFile(configResource);
                this.scriptComponent.initialise();
                Bindings ns = this.scriptComponent.getScriptEngine().createBindings();
                this.populateBindings(ns);
                this.scriptComponent.runScript(ns);
            }
            if (!this.managementContext.isInitialised() && !this.managementContext.isInitialising()) {
                this.managementContext.initialise();
            }
            if (System.getProperty("org.mule.start.after.config", "true").equalsIgnoreCase("true") && this.isStartContext() && !this.managementContext.isStarted()) {
                this.managementContext.start();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        return this.managementContext;
    }

    protected void populateBindings(Bindings bindings) {
        bindings.put("managementContext", (Object)this.managementContext);
    }
}

