/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import org.mule.MuleServer;
import org.mule.components.script.jsr223.Scriptable;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.builders.i18n.BuildersMessages;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.registry.Registry;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.util.PropertiesUtils;

public class ScriptConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    public static final String SCRIPT_ENGINE_NAME_PROPERTY = "org.mule.script.engine";
    private Scriptable scriptComponent = new Scriptable();
    protected UMOManagementContext managementContext = null;
    protected boolean initialised = false;

    public ScriptConfigurationBuilder() throws UMOException {
        String scriptName = System.getProperty(SCRIPT_ENGINE_NAME_PROPERTY);
        if (scriptName == null) {
            throw new IllegalArgumentException(BuildersMessages.systemPropertyNotSet((String)SCRIPT_ENGINE_NAME_PROPERTY).getMessage());
        }
        this.scriptComponent.setScriptEngineName(scriptName);
    }

    public ScriptConfigurationBuilder(String scriptEngineName) throws UMOException {
        this(scriptEngineName, true);
    }

    public ScriptConfigurationBuilder(String scriptEngineName, boolean createDefaultRegistry) throws UMOException {
        this.scriptComponent.setScriptEngineName(scriptEngineName);
    }

    public UMOManagementContext configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        try {
            MuleApplicationContext context = new MuleApplicationContext(new String[]{this.getDefaultConfigResource()});
            this.managementContext = context.getManagementContext();
            MuleServer.setManagementContext((UMOManagementContext)this.managementContext);
            ReaderResource[] readers = ReaderResource.parseResources((String)configResources, (String)"UTF-8");
            if (startupPropertiesFile != null) {
                return this.configure(readers, PropertiesUtils.loadProperties((String)startupPropertiesFile, ((Object)((Object)this)).getClass()));
            }
            return this.configure(readers, null);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public UMOManagementContext configure(ReaderResource[] configResources, Properties startupProperties) throws ConfigurationException {
        try {
            if (startupProperties != null) {
                Registry registry = this.managementContext.getRegistry();
                Iterator<Map.Entry<Object, Object>> iterator = startupProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> e = iterator.next();
                    registry.registerObject(e.getKey().toString(), e.getValue(), this.managementContext);
                }
            }
            for (int i = 0; i < configResources.length; ++i) {
                ReaderResource configResource = configResources[i];
                this.scriptComponent.setScriptFile(configResource.getDescription());
                this.scriptComponent.initialise();
                Bindings ns = this.scriptComponent.getScriptEngine().createBindings();
                this.populateBindings(ns);
                this.scriptComponent.runScript(ns);
            }
            if (!this.managementContext.isInitialised() && !this.managementContext.isInitialising()) {
                this.managementContext.initialise();
            }
            if (System.getProperty("org.mule.start.after.config", "true").equalsIgnoreCase("true") && this.isStartContext() && !this.managementContext.isStarted()) {
                this.managementContext.start();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        return this.managementContext;
    }

    protected void populateBindings(Bindings bindings) {
        bindings.put("managementContext", (Object)this.managementContext);
    }
}

