/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.script;

import javax.script.CompiledScript;
import javax.script.Namespace;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.mule.components.script.jsr223.Scriptable;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class ScriptTransformer
extends AbstractEventAwareTransformer {
    private static final long serialVersionUID = -2384663903730064892L;
    protected Scriptable scriptable = new Scriptable();

    public Object transform(Object src, String encoding, UMOEventContext context) throws TransformerException {
        Namespace ns = this.getScriptEngine().createNamespace();
        this.populateNamespace(ns, context, src);
        try {
            return this.scriptable.runScript(ns);
        }
        catch (ScriptException e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    protected void populateNamespace(Namespace namespace, UMOEventContext context, Object src) {
        namespace.put((Object)"context", (Object)context);
        namespace.put((Object)"message", (Object)context.getMessage());
        namespace.put((Object)"src", src);
        namespace.put((Object)"transformertNamespace", (Object)namespace);
        namespace.put((Object)"log", (Object)this.logger);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        this.scriptable.initialise();
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptable.getScriptEngine();
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptable.setScriptEngine(scriptEngine);
    }

    public CompiledScript getCompiledScript() {
        return this.scriptable.getCompiledScript();
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.scriptable.setCompiledScript(compiledScript);
    }

    public String getScriptText() {
        return this.scriptable.getScriptText();
    }

    public void setScriptText(String scriptText) {
        this.scriptable.setScriptText(scriptText);
    }

    public String getScriptFile() {
        return this.scriptable.getScriptFile();
    }

    public void setScriptFile(String scriptFile) {
        this.scriptable.setScriptFile(scriptFile);
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptable.setScriptEngineName(scriptEngineName);
    }

    public String getScriptEngineName() {
        return this.scriptable.getScriptEngineName();
    }

    Scriptable getScriptable() {
        return this.scriptable;
    }

    void setScriptable(Scriptable scriptable) {
        this.scriptable = scriptable;
    }

    public Object clone() throws CloneNotSupportedException {
        ScriptTransformer trans = (ScriptTransformer)((Object)super.clone());
        trans.setScriptable(this.scriptable);
        return trans;
    }
}

