/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.objectweb.asm.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.objectweb.asm.AnnotationVisitor;
import org.jruby.objectweb.asm.Attribute;
import org.jruby.objectweb.asm.Handle;
import org.jruby.objectweb.asm.Label;
import org.jruby.objectweb.asm.MethodVisitor;
import org.jruby.objectweb.asm.Opcodes;
import org.jruby.objectweb.asm.Type;
import org.jruby.objectweb.asm.TypePath;
import org.jruby.objectweb.asm.util.CheckAnnotationAdapter;
import org.jruby.objectweb.asm.util.CheckClassAdapter;
import org.jruby.objectweb.asm.util.CheckMethodAdapter$1;

public class CheckMethodAdapter
extends MethodVisitor {
    public int version;
    private int access;
    private boolean startCode;
    private boolean endCode;
    private boolean endMethod;
    private int insnCount;
    private final Map labels;
    private Set usedLabels;
    private int expandedFrames;
    private int compressedFrames;
    private int lastFrame = -1;
    private List handlers;
    private static final int[] TYPE;
    private static Field labelStatusField;
    static /* synthetic */ Class class$org$objectweb$asm$util$CheckMethodAdapter;
    static /* synthetic */ Class class$org$objectweb$asm$Label;

    public CheckMethodAdapter(MethodVisitor methodVisitor) {
        this(methodVisitor, new HashMap());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map map) {
        this(327680, methodVisitor, map);
        if (this.getClass() != class$org$objectweb$asm$util$CheckMethodAdapter) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int n, MethodVisitor methodVisitor, Map map) {
        super(n, methodVisitor);
        this.labels = map;
        this.usedLabels = new HashSet();
        this.handlers = new ArrayList();
    }

    public CheckMethodAdapter(int n, String string2, String string3, MethodVisitor methodVisitor, Map map) {
        this(new CheckMethodAdapter$1(327680, n, string2, string3, null, null, methodVisitor), map);
        this.access = n;
    }

    public void visitParameter(String string2, int n) {
        if (string2 != null) {
            CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "name");
        }
        CheckClassAdapter.checkAccess(n, 36880);
        super.visitParameter(string2, n);
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(string2, bl));
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string2, boolean bl) {
        this.checkEndMethod();
        int n2 = n >>> 24;
        if (n2 != 1 && n2 != 18 && n2 != 20 && n2 != 21 && n2 != 22 && n2 != 23) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(n, typePath, string2, bl));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.checkEndMethod();
        return new CheckAnnotationAdapter(super.visitAnnotationDefault(), false);
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(super.visitParameterAnnotation(n, string2, bl));
    }

    public void visitAttribute(Attribute attribute) {
        this.checkEndMethod();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute);
    }

    public void visitCode() {
        if ((this.access & 0x400) != 0) {
            throw new RuntimeException("Abstract methods cannot have code");
        }
        this.startCode = true;
        super.visitCode();
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        int n5;
        int n6;
        if (this.insnCount == this.lastFrame) {
            throw new IllegalStateException("At most one frame can be visited at a given code location.");
        }
        this.lastFrame = this.insnCount;
        switch (n) {
            case -1: 
            case 0: {
                n6 = Integer.MAX_VALUE;
                n5 = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                n6 = 0;
                n5 = 0;
                break;
            }
            case 4: {
                n6 = 0;
                n5 = 1;
                break;
            }
            case 1: 
            case 2: {
                n6 = 3;
                n5 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid frame type " + n);
            }
        }
        if (n2 > n6) {
            throw new IllegalArgumentException("Invalid nLocal=" + n2 + " for frame type " + n);
        }
        if (n3 > n5) {
            throw new IllegalArgumentException("Invalid nStack=" + n3 + " for frame type " + n);
        }
        if (n != 2) {
            if (n2 > 0 && (objectArray == null || objectArray.length < n2)) {
                throw new IllegalArgumentException("Array local[] is shorter than nLocal");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                this.checkFrameValue(objectArray[n4]);
            }
        }
        if (n3 > 0 && (objectArray2 == null || objectArray2.length < n3)) {
            throw new IllegalArgumentException("Array stack[] is shorter than nStack");
        }
        for (n4 = 0; n4 < n3; ++n4) {
            this.checkFrameValue(objectArray2[n4]);
        }
        if (n == -1) {
            ++this.expandedFrames;
        } else {
            ++this.compressedFrames;
        }
        if (this.expandedFrames > 0 && this.compressedFrames > 0) {
            throw new RuntimeException("Expanded and compressed frames must not be mixed.");
        }
        super.visitFrame(n, n2, objectArray, n3, objectArray2);
    }

    public void visitInsn(int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 0);
        super.visitInsn(n);
        ++this.insnCount;
    }

    public void visitIntInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 1);
        switch (n) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(n2, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(n2, "Invalid operand");
                break;
            }
            default: {
                if (n2 >= 4 && n2 <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + n2);
            }
        }
        super.visitIntInsn(n, n2);
        ++this.insnCount;
    }

    public void visitVarInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 2);
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid variable index");
        super.visitVarInsn(n, n2);
        ++this.insnCount;
    }

    public void visitTypeInsn(int n, String string2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 3);
        CheckMethodAdapter.checkInternalName(string2, "type");
        if (n == 187 && string2.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + string2);
        }
        super.visitTypeInsn(n, string2);
        ++this.insnCount;
    }

    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 4);
        CheckMethodAdapter.checkInternalName(string2, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, string3, "name");
        CheckMethodAdapter.checkDesc(string4, false);
        super.visitFieldInsn(n, string2, string3, string4);
        ++this.insnCount;
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        if (this.api >= 327680) {
            super.visitMethodInsn(n, string2, string3, string4);
            return;
        }
        this.doVisitMethodInsn(n, string2, string3, string4, n == 185);
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4, boolean bl) {
        if (this.api < 327680) {
            super.visitMethodInsn(n, string2, string3, string4, bl);
            return;
        }
        this.doVisitMethodInsn(n, string2, string3, string4, bl);
    }

    private void doVisitMethodInsn(int n, String string2, String string3, String string4, boolean bl) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 5);
        if (n != 183 || !"<init>".equals(string3)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, string3, "name");
        }
        CheckMethodAdapter.checkInternalName(string2, "owner");
        CheckMethodAdapter.checkMethodDesc(string4);
        if (n == 182 && bl) {
            throw new IllegalArgumentException("INVOKEVIRTUAL can't be used with interfaces");
        }
        if (n == 185 && !bl) {
            throw new IllegalArgumentException("INVOKEINTERFACE can't be used with classes");
        }
        if (this.mv != null) {
            this.mv.visitMethodInsn(n, string2, string3, string4, bl);
        }
        ++this.insnCount;
    }

    public void visitInvokeDynamicInsn(String string2, String string3, Handle handle, Object ... objectArray) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkMethodIdentifier(this.version, string2, "name");
        CheckMethodAdapter.checkMethodDesc(string3);
        if (handle.getTag() != 6 && handle.getTag() != 8) {
            throw new IllegalArgumentException("invalid handle tag " + handle.getTag());
        }
        for (int j = 0; j < objectArray.length; ++j) {
            this.checkLDCConstant(objectArray[j]);
        }
        super.visitInvokeDynamicInsn(string2, string3, handle, objectArray);
        ++this.insnCount;
    }

    public void visitJumpInsn(int n, Label label2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n, 6);
        this.checkLabel(label2, false, "label");
        CheckMethodAdapter.checkNonDebugLabel(label2);
        super.visitJumpInsn(n, label2);
        this.usedLabels.add(label2);
        ++this.insnCount;
    }

    public void visitLabel(Label label2) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label2, false, "label");
        if (this.labels.get(label2) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label2, new Integer(this.insnCount));
        super.visitLabel(label2);
    }

    public void visitLdcInsn(Object object) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLDCConstant(object);
        super.visitLdcInsn(object);
        ++this.insnCount;
    }

    public void visitIincInsn(int n, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid variable index");
        CheckMethodAdapter.checkSignedShort(n2, "Invalid increment");
        super.visitIincInsn(n, n2);
        ++this.insnCount;
    }

    public void visitTableSwitchInsn(int n, int n2, Label label2, Label ... labelArray) {
        int n3;
        this.checkStartCode();
        this.checkEndCode();
        if (n2 < n) {
            throw new IllegalArgumentException("Max = " + n2 + " must be greater than or equal to min = " + n);
        }
        this.checkLabel(label2, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label2);
        if (labelArray == null || labelArray.length != n2 - n + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.checkLabel(labelArray[n3], false, "label at index " + n3);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[n3]);
        }
        super.visitTableSwitchInsn(n, n2, label2, labelArray);
        for (n3 = 0; n3 < labelArray.length; ++n3) {
            this.usedLabels.add(labelArray[n3]);
        }
        ++this.insnCount;
    }

    public void visitLookupSwitchInsn(Label label2, int[] nArray, Label[] labelArray) {
        int n;
        this.checkEndCode();
        this.checkStartCode();
        this.checkLabel(label2, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label2);
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (n = 0; n < labelArray.length; ++n) {
            this.checkLabel(labelArray[n], false, "label at index " + n);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[n]);
        }
        super.visitLookupSwitchInsn(label2, nArray, labelArray);
        this.usedLabels.add(label2);
        for (n = 0; n < labelArray.length; ++n) {
            this.usedLabels.add(labelArray[n]);
        }
        ++this.insnCount;
    }

    public void visitMultiANewArrayInsn(String string2, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkDesc(string2, false);
        if (string2.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + string2);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + n);
        }
        if (n > string2.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + n);
        }
        super.visitMultiANewArrayInsn(string2, n);
        ++this.insnCount;
    }

    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string2, boolean bl) {
        this.checkStartCode();
        this.checkEndCode();
        int n2 = n >>> 24;
        if (n2 != 67 && n2 != 68 && n2 != 69 && n2 != 70 && n2 != 71 && n2 != 72 && n2 != 73 && n2 != 74 && n2 != 75) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(super.visitInsnAnnotation(n, typePath, string2, bl));
    }

    public void visitTryCatchBlock(Label label2, Label label3, Label label4, String string2) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label2, false, "start label");
        this.checkLabel(label3, false, "end label");
        this.checkLabel(label4, false, "handler label");
        CheckMethodAdapter.checkNonDebugLabel(label2);
        CheckMethodAdapter.checkNonDebugLabel(label3);
        CheckMethodAdapter.checkNonDebugLabel(label4);
        if (this.labels.get(label2) != null || this.labels.get(label3) != null || this.labels.get(label4) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (string2 != null) {
            CheckMethodAdapter.checkInternalName(string2, "type");
        }
        super.visitTryCatchBlock(label2, label3, label4, string2);
        this.handlers.add(label2);
        this.handlers.add(label3);
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string2, boolean bl) {
        this.checkStartCode();
        this.checkEndCode();
        int n2 = n >>> 24;
        if (n2 != 66) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string2, false);
        return new CheckAnnotationAdapter(super.visitTryCatchAnnotation(n, typePath, string2, bl));
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label2, Label label3, int n) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "name");
        CheckMethodAdapter.checkDesc(string3, false);
        this.checkLabel(label2, true, "start label");
        this.checkLabel(label3, true, "end label");
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid variable index");
        int n2 = (Integer)this.labels.get(label2);
        int n3 = (Integer)this.labels.get(label3);
        if (n3 < n2) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        super.visitLocalVariable(string2, string3, string4, label2, label3, n);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string2, boolean bl) {
        this.checkStartCode();
        this.checkEndCode();
        int n2 = n >>> 24;
        if (n2 != 64 && n2 != 65) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(n2));
        }
        CheckClassAdapter.checkTypeRefAndPath(n, typePath);
        CheckMethodAdapter.checkDesc(string2, false);
        if (labelArray == null || labelArray2 == null || nArray == null || labelArray2.length != labelArray.length || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("Invalid start, end and index arrays (must be non null and of identical length");
        }
        for (int j = 0; j < labelArray.length; ++j) {
            this.checkLabel(labelArray[j], true, "start label");
            this.checkLabel(labelArray2[j], true, "end label");
            CheckMethodAdapter.checkUnsignedShort(nArray[j], "Invalid variable index");
            int n3 = (Integer)this.labels.get(labelArray[j]);
            int n4 = (Integer)this.labels.get(labelArray2[j]);
            if (n4 >= n3) continue;
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        return super.visitLocalVariableAnnotation(n, typePath, labelArray, labelArray2, nArray, string2, bl);
    }

    public void visitLineNumber(int n, Label label2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid line number");
        this.checkLabel(label2, true, "start label");
        super.visitLineNumber(n, label2);
    }

    public void visitMaxs(int n, int n2) {
        Object object;
        this.checkStartCode();
        this.checkEndCode();
        this.endCode = true;
        Iterator iterator = this.usedLabels.iterator();
        while (iterator.hasNext()) {
            object = (Label)iterator.next();
            if (this.labels.get(object) != null) continue;
            throw new IllegalStateException("Undefined label used");
        }
        int n3 = 0;
        while (n3 < this.handlers.size()) {
            object = (Integer)this.labels.get(this.handlers.get(n3++));
            Integer n4 = (Integer)this.labels.get(this.handlers.get(n3++));
            if (object == null || n4 == null) {
                throw new IllegalStateException("Undefined try catch block labels");
            }
            if (n4 > (Integer)object) continue;
            throw new IllegalStateException("Emty try catch block handler range");
        }
        CheckMethodAdapter.checkUnsignedShort(n, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid max locals");
        super.visitMaxs(n, n2);
    }

    public void visitEnd() {
        this.checkEndMethod();
        this.endMethod = true;
        super.visitEnd();
    }

    void checkStartCode() {
        if (!this.startCode) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    void checkEndCode() {
        if (this.endCode) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    void checkEndMethod() {
        if (this.endMethod) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    void checkFrameValue(Object object) {
        if (object == Opcodes.TOP || object == Opcodes.INTEGER || object == Opcodes.FLOAT || object == Opcodes.LONG || object == Opcodes.DOUBLE || object == Opcodes.NULL || object == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (object instanceof String) {
            CheckMethodAdapter.checkInternalName((String)object, "Invalid stack frame value");
            return;
        }
        if (!(object instanceof Label)) {
            throw new IllegalArgumentException("Invalid stack frame value: " + object);
        }
        this.usedLabels.add((Label)object);
    }

    static void checkOpcode(int n, int n2) {
        if (n < 0 || n > 199 || TYPE[n] != n2) {
            throw new IllegalArgumentException("Invalid opcode: " + n);
        }
    }

    static void checkSignedByte(int n, String string2) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException(string2 + " (must be a signed byte): " + n);
        }
    }

    static void checkSignedShort(int n, String string2) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException(string2 + " (must be a signed short): " + n);
        }
    }

    static void checkUnsignedShort(int n, String string2) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(string2 + " (must be an unsigned short): " + n);
        }
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + object);
        }
    }

    void checkLDCConstant(Object object) {
        if (object instanceof Type) {
            int n = ((Type)object).getSort();
            if (n != 10 && n != 9 && n != 11) {
                throw new IllegalArgumentException("Illegal LDC constant value");
            }
            if (n != 11 && (this.version & 0xFFFF) < 49) {
                throw new IllegalArgumentException("ldc of a constant class requires at least version 1.5");
            }
            if (n == 11 && (this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a method type requires at least version 1.7");
            }
        } else if (object instanceof Handle) {
            if ((this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a handle requires at least version 1.7");
            }
            int n = ((Handle)object).getTag();
            if (n < 1 || n > 9) {
                throw new IllegalArgumentException("invalid handle tag " + n);
            }
        } else {
            CheckMethodAdapter.checkConstant(object);
        }
    }

    static void checkUnqualifiedName(int n, String string2, String string3) {
        if ((n & 0xFFFF) < 49) {
            CheckMethodAdapter.checkIdentifier(string2, string3);
        } else {
            for (int j = 0; j < string2.length(); ++j) {
                if (".;[/".indexOf(string2.charAt(j)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid unqualified name): " + string2);
            }
        }
    }

    static void checkIdentifier(String string2, String string3) {
        CheckMethodAdapter.checkIdentifier(string2, 0, -1, string3);
    }

    static void checkIdentifier(String string2, int n, int n2, String string3) {
        if (string2 == null || (n2 == -1 ? string2.length() <= n : n2 <= n)) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(string2.charAt(n))) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid Java identifier): " + string2);
        }
        int n3 = n2 == -1 ? string2.length() : n2;
        for (int j = n + 1; j < n3; ++j) {
            if (Character.isJavaIdentifierPart(string2.charAt(j))) continue;
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid Java identifier): " + string2);
        }
    }

    static void checkMethodIdentifier(int n, String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if ((n & 0xFFFF) >= 49) {
            for (int j = 0; j < string2.length(); ++j) {
                if (".;[/<>".indexOf(string2.charAt(j)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + string3 + " (must be a valid unqualified name): " + string2);
            }
            return;
        }
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + string2);
        }
        for (int j = 1; j < string2.length(); ++j) {
            if (Character.isJavaIdentifierPart(string2.charAt(j))) continue;
            throw new IllegalArgumentException("Invalid " + string3 + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + string2);
        }
    }

    static void checkInternalName(String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must not be null or empty)");
        }
        if (string2.charAt(0) == '[') {
            CheckMethodAdapter.checkDesc(string2, false);
        } else {
            CheckMethodAdapter.checkInternalName(string2, 0, -1, string3);
        }
    }

    static void checkInternalName(String string2, int n, int n2, String string3) {
        int n3 = n2 == -1 ? string2.length() : n2;
        try {
            int n4;
            int n5 = n;
            do {
                if ((n4 = string2.indexOf(47, n5 + 1)) == -1 || n4 > n3) {
                    n4 = n3;
                }
                CheckMethodAdapter.checkIdentifier(string2, n5, n4, null);
                n5 = n4 + 1;
            } while (n4 != n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid " + string3 + " (must be a fully qualified class name in internal form): " + string2);
        }
    }

    static void checkDesc(String string2, boolean bl) {
        int n = CheckMethodAdapter.checkDesc(string2, 0, bl);
        if (n != string2.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
    }

    static int checkDesc(String string2, int n, boolean bl) {
        if (string2 == null || n >= string2.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (string2.charAt(n)) {
            case 'V': {
                if (bl) {
                    return n + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
            case '[': {
                int n2;
                for (n2 = n + 1; n2 < string2.length() && string2.charAt(n2) == '['; ++n2) {
                }
                if (n2 < string2.length()) {
                    return CheckMethodAdapter.checkDesc(string2, n2, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            }
            case 'L': {
                int n3 = string2.indexOf(59, n);
                if (n3 == -1 || n3 - n < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string2);
                }
                try {
                    CheckMethodAdapter.checkInternalName(string2, n + 1, n3, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string2);
                }
                return n3 + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + string2);
    }

    static void checkMethodDesc(String string2) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (string2.charAt(0) != '(' || string2.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
        int n = 1;
        if (string2.charAt(n) != ')') {
            do {
                if (string2.charAt(n) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + string2);
            } while ((n = CheckMethodAdapter.checkDesc(string2, n, false)) < string2.length() && string2.charAt(n) != ')');
        }
        if ((n = CheckMethodAdapter.checkDesc(string2, n + 1, true)) != string2.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string2);
        }
    }

    void checkLabel(Label label2, boolean bl, String string2) {
        if (label2 == null) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null)");
        }
        if (bl && this.labels.get(label2) == null) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be visited first)");
        }
    }

    private static void checkNonDebugLabel(Label label2) {
        Field field2 = CheckMethodAdapter.getLabelStatusField();
        int n = 0;
        try {
            n = field2 == null ? 0 : (Integer)field2.get(label2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Internal error");
        }
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("Labels used for debug info cannot be reused for control flow");
        }
    }

    private static Field getLabelStatusField() {
        if (labelStatusField == null && (labelStatusField = CheckMethodAdapter.getLabelField("a")) == null) {
            labelStatusField = CheckMethodAdapter.getLabelField("status");
        }
        return labelStatusField;
    }

    private static Field getLabelField(String string2) {
        try {
            Field field2 = class$org$objectweb$asm$Label.getDeclaredField(string2);
            field2.setAccessible(true);
            return field2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static {
        CheckMethodAdapter._clinit_();
        String string2 = "BBBBBBBBBBBBBBBBCCIAADDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBDDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBJBBBBBBBBBBBBBBBBBBBBHHHHHHHHHHHHHHHHDKLBBBBBBFFFFGGGGAECEBBEEBBAMHHAA";
        TYPE = new int[string2.length()];
        for (int j = 0; j < TYPE.length; ++j) {
            CheckMethodAdapter.TYPE[j] = string2.charAt(j) - 65 - 1;
        }
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = classNotFoundException.getMessage();
            throw new NoClassDefFoundError(string3);
        }
    }

    private static void _clinit_() {
        class$org$objectweb$asm$util$CheckMethodAdapter = CheckMethodAdapter.class$("org.jruby.objectweb.asm.util.CheckMethodAdapter");
        class$org$objectweb$asm$Label = CheckMethodAdapter.class$("org.jruby.objectweb.asm.Label");
    }
}

