/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ClassVarAsgnNode
extends AssignableNode
implements INameNode {
    private String name;

    public ClassVarAsgnNode(ISourcePosition position, String name2, Node valueNode) {
        super(position, valueNode);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CLASSVARASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitClassVarAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return ClassVarAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime);
        if (rubyClass == null) {
            rubyClass = self2.getMetaClass();
        }
        return rubyClass.setClassVar(this.name, this.getValueNode().interpret(runtime, context, self2, aBlock));
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject value2, Block block, boolean checkArity) {
        ASTInterpreter.getClassVariableBase(context, runtime).setClassVar(this.name, value2);
        return runtime.getNil();
    }
}

