/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module;

import javax.inject.Inject;
import org.mule.DefaultMessageCollection;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class MuleRequesterModule {
    @Inject
    private MuleContext muleContext;

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void request(MuleEvent muleEvent, String resource, long timeout, String returnClass, Boolean throwExceptionOnTimeout) throws MuleException {
        MuleMessage message = this.muleContext.getClient().request(resource, timeout);
        Object result = null;
        if (message != null) {
            result = message.getPayload();
            if (returnClass != null) {
                try {
                    Transformer transformer = this.muleContext.getRegistry().lookupTransformer(DataTypeFactory.create(result.getClass()), DataTypeFactory.create(Class.forName(returnClass)));
                    result = transformer.transform(result);
                }
                catch (ClassNotFoundException e) {
                    throw new DefaultMuleException((Throwable)e);
                }
            }
            message.setPayload(result);
            muleEvent.setMessage(message);
        } else {
            if (Boolean.TRUE.equals(throwExceptionOnTimeout)) {
                throw new DefaultMuleException("No message received in the configured timeout - " + timeout);
            }
            muleEvent.getMessage().setPayload((Object)NullPayload.getInstance());
        }
    }

    public void requestCollection(MuleEvent muleEvent, String resource, long timeout, String returnClass, Boolean throwExceptionOnTimeout, int count) throws MuleException {
        DefaultMessageCollection resultCollection = new DefaultMessageCollection(this.muleContext);
        boolean keepRequesting = count == -1 || count > 0;
        int currentCount = 0;
        while (keepRequesting) {
            MuleMessage message = this.muleContext.getClient().request(resource, timeout);
            if (message != null) {
                Object result = message.getPayload();
                if (returnClass != null) {
                    try {
                        Transformer transformer = this.muleContext.getRegistry().lookupTransformer(DataTypeFactory.create(result.getClass()), DataTypeFactory.create(Class.forName(returnClass)));
                        result = transformer.transform(result);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DefaultMuleException((Throwable)e);
                    }
                }
                message.setPayload(result);
                resultCollection.addMessage(message);
                keepRequesting = count == -1 || ++currentCount < count;
                continue;
            }
            if (Boolean.TRUE.equals(throwExceptionOnTimeout)) {
                throw new DefaultMuleException("No message received in the configured timeout - " + timeout);
            }
            keepRequesting = false;
        }
        muleEvent.setMessage((MuleMessage)resultCollection);
    }
}

