/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.pgp.filters;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.EncryptionStrategy;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.security.Authentication;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.api.security.UnauthorisedException;
import org.mule.runtime.core.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.security.AbstractOperationSecurityFilter;
import org.mule.runtime.module.pgp.LiteralMessage;
import org.mule.runtime.module.pgp.MessageFactory;
import org.mule.runtime.module.pgp.PGPAuthentication;
import org.mule.runtime.module.pgp.PGPKeyRing;
import org.mule.runtime.module.pgp.PgpMessage;
import org.mule.runtime.module.pgp.SignedMessage;
import org.mule.runtime.module.pgp.i18n.PGPMessages;

public class PGPSecurityFilter
extends AbstractOperationSecurityFilter {
    private EncryptionStrategy strategy;
    private String strategyName;
    private boolean signRequired;
    private PGPKeyRing keyManager;

    protected Event authenticateInbound(Event event) throws UnauthorisedException, UnknownAuthenticationTypeException {
        Authentication authResult;
        PGPAuthentication authentication;
        InternalMessage message = event.getMessage();
        String userId = (String)((Object)this.getCredentialsAccessor().getCredentials(event));
        byte[] creds = null;
        try {
            creds = event.getMessageAsBytes(this.muleContext);
            creds = this.strategy.decrypt(creds, null);
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), (Throwable)e1);
        }
        try {
            authentication = new PGPAuthentication(userId, this.decodeMsgRaw(creds), event);
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), (Throwable)e1);
        }
        try {
            authResult = this.getSecurityManager().authenticate((Authentication)authentication);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Authentication request for user: " + userId + " failed: " + e.toString());
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser((Object)userId), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Authentication success: " + authResult.toString());
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        event.getSession().setSecurityContext(context);
        try {
            return this.updatePayload(message, this.getUnencryptedMessageWithoutSignature((PGPAuthentication)authResult), event);
        }
        catch (Exception e2) {
            throw new UnauthorisedException(event, context, (SecurityFilter)this);
        }
    }

    private PgpMessage decodeMsgRaw(byte[] raw) throws Exception {
        return MessageFactory.getMessage(raw);
    }

    private String getUnencryptedMessageWithoutSignature(PGPAuthentication auth) throws Exception {
        PgpMessage msg = (PgpMessage)auth.getCredentials();
        if (msg instanceof SignedMessage) {
            msg = ((SignedMessage)msg).getContents();
        }
        if (msg instanceof LiteralMessage) {
            return ((LiteralMessage)msg).getTextData();
        }
        throw new Exception("Wrong data");
    }

    protected void doInitialise() throws InitialisationException {
        if (this.strategyName != null) {
            this.strategy = this.muleContext.getSecurityManager().getEncryptionStrategy(this.strategyName);
        }
        if (this.strategy == null) {
            throw new InitialisationException(PGPMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }

    public EncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(EncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategyName(String name) {
        this.strategyName = name;
    }

    public boolean isSignRequired() {
        return this.signRequired;
    }

    public void setSignRequired(boolean signRequired) {
        this.signRequired = signRequired;
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }
}

