/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.pgp;

import java.util.concurrent.Semaphore;
import org.mule.runtime.module.pgp.AbstractTransformPolicy;

public class TransformPerRequestInChunksPolicy
extends AbstractTransformPolicy {
    private Semaphore writeSemaphore = new Semaphore(1);
    private long chunkSize;
    private long bytesActuallyRequested;

    public TransformPerRequestInChunksPolicy(long chunkSize) {
        this.chunkSize = chunkSize;
        this.bytesActuallyRequested = 0L;
    }

    @Override
    public void readRequest(long length) {
        this.bytesActuallyRequested += length;
        super.readRequest(length);
        this.writeSemaphore.release();
    }

    @Override
    public void release() {
        this.writeSemaphore.release();
        super.release();
    }

    @Override
    protected Thread getCopyingThread() {
        return new PerRequestWork();
    }

    private class PerRequestWork
    extends AbstractTransformPolicy.TransformerWork {
        private PerRequestWork() {
        }

        @Override
        protected void execute() throws Exception {
            TransformPerRequestInChunksPolicy.this.getTransformer().initialize(TransformPerRequestInChunksPolicy.this.getInputStream().getOut());
            boolean finishWriting = false;
            while (!finishWriting && !TransformPerRequestInChunksPolicy.this.isClosed) {
                TransformPerRequestInChunksPolicy.this.writeSemaphore.acquire();
                long requested = TransformPerRequestInChunksPolicy.this.bytesActuallyRequested;
                long updatedRequest = (long)(Math.ceil((double)requested / (double)TransformPerRequestInChunksPolicy.this.chunkSize) * (double)TransformPerRequestInChunksPolicy.this.chunkSize);
                TransformPerRequestInChunksPolicy.this.getBytesRequested().set(updatedRequest);
                finishWriting = TransformPerRequestInChunksPolicy.this.getTransformer().write(TransformPerRequestInChunksPolicy.this.getInputStream().getOut(), TransformPerRequestInChunksPolicy.this.getBytesRequested());
            }
        }
    }
}

