/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.mule.module.pgp.StreamTransformer;
import org.mule.module.pgp.config.PGPOutputMode;

public class EncryptStreamTransformer
implements StreamTransformer {
    private PGPPublicKey publicKey;
    private Provider provider;
    private final int algorithm;
    private OutputStream pgpOutputStream;
    private OutputStream compressedEncryptedOutputStream;
    private OutputStream encryptedOutputStream;
    private ByteArrayOutputStream outputStream;
    private PGPOutputMode pgpOutputMode;
    private OutputStream result;
    private String streamName = "stream";
    private boolean signatureEnabled = false;
    private PGPPrivateKey signerPrivateKey = null;
    private String signerId;
    private PGPSignatureGenerator signatureGenerator = null;

    public EncryptStreamTransformer(PGPPublicKey publicKey, Provider provider, int algorithm, PGPOutputMode pgpOutputMode, String streamName) throws IOException {
        this(publicKey, provider, algorithm, pgpOutputMode);
        if (streamName != null) {
            this.streamName = streamName;
        }
    }

    public EncryptStreamTransformer(PGPPublicKey publicKey, Provider provider, int algorithm, PGPOutputMode pgpOutputMode) throws IOException {
        Validate.notNull((Object)publicKey, (String)"The publicKey should not be null");
        this.publicKey = publicKey;
        this.provider = provider;
        this.algorithm = algorithm;
        this.pgpOutputMode = pgpOutputMode;
        this.outputStream = new ByteArrayOutputStream();
    }

    public EncryptStreamTransformer signContentsWith(PGPPrivateKey signerPrivateKey, String signerId) {
        this.signerPrivateKey = signerPrivateKey;
        this.signerId = signerId;
        this.signatureEnabled = true;
        return this;
    }

    @Override
    public InputStream process(InputStream data) throws Exception {
        this.result = this.pgpOutputMode == PGPOutputMode.ARMOR ? new ArmoredOutputStream((OutputStream)this.outputStream) : this.outputStream;
        BcPGPDataEncryptorBuilder encryptorBuilder = new BcPGPDataEncryptorBuilder(this.algorithm);
        if (this.signatureEnabled) {
            encryptorBuilder.setWithIntegrityPacket(true);
        }
        PGPEncryptedDataGenerator encrDataGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder, false);
        BcPublicKeyKeyEncryptionMethodGenerator methodGenerator = new BcPublicKeyKeyEncryptionMethodGenerator(this.publicKey);
        encrDataGen.addMethod((PGPKeyEncryptionMethodGenerator)methodGenerator);
        this.encryptedOutputStream = encrDataGen.open(this.result, new byte[65536]);
        PGPCompressedDataGenerator comprDataGen = new PGPCompressedDataGenerator(1);
        this.compressedEncryptedOutputStream = comprDataGen.open(this.encryptedOutputStream, new byte[65536]);
        if (this.signatureEnabled) {
            BcPGPContentSignerBuilder signerBuilder = new BcPGPContentSignerBuilder(this.signerPrivateKey.getPublicKeyPacket().getAlgorithm(), 2);
            this.signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)signerBuilder);
            this.signatureGenerator.init(0, this.signerPrivateKey);
            PGPSignatureSubpacketGenerator signatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            signatureSubpacketGenerator.setSignerUserID(false, this.signerId);
            this.signatureGenerator.setHashedSubpackets(signatureSubpacketGenerator.generate());
            this.signatureGenerator.generateOnePassVersion(false).encode(this.compressedEncryptedOutputStream);
        }
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        this.pgpOutputStream = lData.open(this.compressedEncryptedOutputStream, 'b', this.streamName, new Date(), new byte[65536]);
        this.write(data);
        return new ByteArrayInputStream(this.outputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(InputStream toBeEncrypted) throws IOException, PGPException {
        try {
            if (!this.signatureEnabled) {
                IOUtils.copy((InputStream)toBeEncrypted, (OutputStream)this.pgpOutputStream);
            } else {
                int readBytesLength;
                byte[] buf = new byte[65536];
                while ((readBytesLength = toBeEncrypted.read(buf)) > 0) {
                    this.pgpOutputStream.write(buf, 0, readBytesLength);
                    this.signatureGenerator.update(buf, 0, readBytesLength);
                }
            }
        }
        finally {
            this.pgpOutputStream.close();
            if (this.signatureEnabled) {
                this.signatureGenerator.generate().encode(this.compressedEncryptedOutputStream);
            }
            this.compressedEncryptedOutputStream.close();
            this.encryptedOutputStream.close();
            this.result.close();
            toBeEncrypted.close();
            this.outputStream.close();
        }
    }
}

