/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp.config;

import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.parsers.generic.NamedDefinitionParser;
import org.mule.config.spring.parsers.generic.ParentDefinitionParser;
import org.mule.config.spring.parsers.specific.SecurityFilterDefinitionParser;
import org.mule.module.pgp.KeyBasedEncryptionStrategy;
import org.mule.module.pgp.PGPSecurityProvider;
import org.mule.module.pgp.filters.PGPSecurityFilter;
import org.mule.util.SecurityUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PgpNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerRestrictedBeanDefinitionParser("security-manager", (BeanDefinitionParser)new NamedDefinitionParser("_muleSecurityManager"));
        this.registerRestrictedBeanDefinitionParser("security-provider", (BeanDefinitionParser)new ChildDefinitionParser("provider", PGPSecurityProvider.class));
        this.registerRestrictedBeanDefinitionParser("security-filters", (BeanDefinitionParser)new ParentDefinitionParser());
        this.registerRestrictedBeanDefinitionParser("security-filter", (BeanDefinitionParser)new SecurityFilterDefinitionParser(PGPSecurityFilter.class));
        this.registerRestrictedBeanDefinitionParser("keybased-encryption-strategy", (BeanDefinitionParser)new ChildDefinitionParser("encryptionStrategy", KeyBasedEncryptionStrategy.class));
    }

    private void registerRestrictedBeanDefinitionParser(String id, final BeanDefinitionParser beanDefinitionParser) {
        this.registerBeanDefinitionParser(id, new BeanDefinitionParser(){

            public BeanDefinition parse(Element element, ParserContext parserContext) {
                if (SecurityUtils.isFipsSecurityModel()) {
                    throw new IllegalStateException(String.format("Cannot use PGP module when using FIPS security model. Element %s is not allowed.", element.getNodeName()));
                }
                return beanDefinitionParser.parse(element, parserContext);
            }
        });
    }
}

