/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.mule.module.pgp.OutputStreamWriter;

public class LazyInputStream
extends InputStream {
    private PipedInputStream in = new PipedInputStream();
    private PipedOutputStream out = new PipedOutputStream(this.in);
    private AtomicBoolean startedCopying = new AtomicBoolean(false);
    private Thread copyingThread;
    private AtomicLong bytesRequested = new AtomicLong(0L);
    private OutputStreamWriter writer;

    public LazyInputStream(OutputStreamWriter writer) throws IOException {
        this.writer = writer;
    }

    private void copyRequest() {
        if (this.startedCopying.compareAndSet(false, true)) {
            this.copyingThread = new WriteWork();
            this.copyingThread.start();
        }
    }

    @Override
    public int available() throws IOException {
        this.copyRequest();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.copyingThread.interrupt();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.bytesRequested.addAndGet(1L);
        this.copyRequest();
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bytesRequested.addAndGet(len);
        this.copyRequest();
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.bytesRequested.addAndGet(b.length);
        this.copyRequest();
        return this.in.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.copyRequest();
        return this.in.skip(n);
    }

    private class WriteWork
    extends Thread {
        private WriteWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LazyInputStream.this.writer.initialize(LazyInputStream.this.out);
                boolean finishWriting = false;
                while (!finishWriting) {
                    finishWriting = LazyInputStream.this.writer.write(LazyInputStream.this.out, LazyInputStream.this.bytesRequested);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)LazyInputStream.this.out);
                while (!this.isInterrupted()) {
                    try {
                        WriteWork.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

