/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ognl.config;

import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.parsers.specific.FilterDefinitionParser;
import org.mule.module.ognl.filters.OGNLFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class OGNLNamespaceHandler
extends NamespaceHandlerSupport {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void init() {
        this.logger.warn(OGNLNamespaceHandler.getDeprecationWarning());
        this.registerBeanDefinitionParser("filter", (BeanDefinitionParser)new FilterDefinitionParser(OGNLFilter.class));
        this.registerBeanDefinitionParser("expression", (BeanDefinitionParser)new CDATABeanDefinitionParser("expression", String.class));
    }

    public static String getDeprecationWarning() {
        return "OGNL module is deprecated and will be removed in Mule 4.0. Use MEL expressions instead.";
    }

    private static class CDATABeanDefinitionParser
    extends ChildDefinitionParser {
        private CDATABeanDefinitionParser(String setterMethod, Class clazz) {
            super(setterMethod, clazz);
        }

        protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
            assembler.extendTarget(this.setterMethod, (Object)element.getFirstChild().getNodeValue(), false);
        }
    }
}

