/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;

public class OGNLFilter
implements UMOFilter {
    private static final Log logger = LogFactory.getLog((Class)OGNLFilter.class);
    private String expression;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean accept(UMOMessage message) {
        if (message == null) {
            return false;
        }
        Object candidate = message.getPayload();
        if (candidate == null) {
            return false;
        }
        if (this.expression == null) {
            logger.warn((Object)"Expression for OGNLFilter is not set");
            return false;
        }
        try {
            Object result = Ognl.getValue((String)this.expression, (Object)candidate);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (OgnlException ex) {
            logger.error((Object)"Error evaluating OGNL expression.", (Throwable)ex);
        }
        return false;
    }
}

