/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal.clientcredentials;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.runtime.module.oauth2.api.RequestAuthenticationException;
import org.mule.runtime.module.oauth2.internal.AbstractGrantType;
import org.mule.runtime.module.oauth2.internal.clientcredentials.ClientCredentialsTokenRequestHandler;
import org.mule.runtime.module.oauth2.internal.tokenmanager.TokenManagerConfig;

public class ClientCredentialsGrantType
extends AbstractGrantType
implements Initialisable,
Startable,
MuleContextAware {
    private String clientId;
    private String clientSecret;
    private ClientCredentialsTokenRequestHandler tokenRequestHandler;
    private MuleContext muleContext;
    private TokenManagerConfig tokenManager;
    private TlsContextFactory tlsContextFactory;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setTokenRequestHandler(ClientCredentialsTokenRequestHandler tokenRequestHandler) {
        this.tokenRequestHandler = tokenRequestHandler;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }

    public void start() throws MuleException {
        this.tokenRequestHandler.refreshAccessToken();
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void initialise() throws InitialisationException {
        if (this.tokenManager == null) {
            this.tokenManager = TokenManagerConfig.createDefault(this.muleContext);
        }
        this.tokenRequestHandler.setApplicationCredentials(this);
        this.tokenRequestHandler.setTokenManager(this.tokenManager);
        if (this.tlsContextFactory != null) {
            this.tokenRequestHandler.setTlsContextFactory(this.tlsContextFactory);
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getRefreshTokenWhen() {
        return this.tokenRequestHandler.getRefreshTokenWhen();
    }

    public void refreshAccessToken() throws MuleException {
        this.tokenRequestHandler.refreshAccessToken();
    }

    public void authenticate(Event muleEvent, HttpRequestBuilder builder) throws MuleException {
        String accessToken = this.tokenManager.getConfigOAuthContext().getContextForResourceOwner("default").getAccessToken();
        if (accessToken == null) {
            throw new RequestAuthenticationException(I18nMessageFactory.createStaticMessage((String)String.format("No access token found. Verify that you have authenticated before trying to execute an operation to the API.", new Object[0])));
        }
        builder.addHeader("Authorization", ClientCredentialsGrantType.buildAuthorizationHeaderContent(accessToken));
    }

    public boolean shouldRetry(Event firstAttemptResponseEvent) {
        Object value = this.muleContext.getExpressionManager().evaluate(this.getRefreshTokenWhen(), firstAttemptResponseEvent).getValue();
        if (!(value instanceof Boolean)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expression %s should return a boolean but return %s", (Object[])new Object[]{this.getRefreshTokenWhen(), value}));
        }
        Boolean shouldRetryRequest = (Boolean)value;
        if (shouldRetryRequest.booleanValue()) {
            try {
                this.refreshAccessToken();
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return shouldRetryRequest;
    }

    public void setTokenManager(TokenManagerConfig tokenManager) {
        this.tokenManager = tokenManager;
    }
}

