/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal.authorizationcode.state;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.util.lock.LockFactory;
import org.mule.runtime.core.util.store.ObjectStoreToMapAdapter;
import org.mule.runtime.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;

public class ConfigOAuthContext {
    private final LockFactory lockFactory;
    private final String configName;
    private final ObjectStoreToMapAdapter<ResourceOwnerOAuthContext> oauthContextStore;

    public ConfigOAuthContext(LockFactory lockFactory, ListableObjectStore<ResourceOwnerOAuthContext> objectStore, String configName) {
        this.lockFactory = lockFactory;
        this.oauthContextStore = new ObjectStoreToMapAdapter(objectStore);
        this.configName = configName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceOwnerOAuthContext getContextForResourceOwner(String resourceOwnerId) {
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = null;
        if (!this.oauthContextStore.containsKey((Object)resourceOwnerId)) {
            Lock lock = this.lockFactory.createLock(this.configName + "-config-oauth-context");
            lock.lock();
            try {
                if (!this.oauthContextStore.containsKey((Object)resourceOwnerId)) {
                    resourceOwnerOAuthContext = new ResourceOwnerOAuthContext(this.createLockForResourceOwner(resourceOwnerId), resourceOwnerId);
                    this.oauthContextStore.put((Serializable)((Object)resourceOwnerId), (Serializable)resourceOwnerOAuthContext);
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (resourceOwnerOAuthContext == null) {
            resourceOwnerOAuthContext = (ResourceOwnerOAuthContext)this.oauthContextStore.get((Object)resourceOwnerId);
            resourceOwnerOAuthContext.setRefreshUserOAuthContextLock(this.createLockForResourceOwner(resourceOwnerId));
        }
        return resourceOwnerOAuthContext;
    }

    private Lock createLockForResourceOwner(String resourceOwnerId) {
        return this.lockFactory.createLock(this.configName + "-" + resourceOwnerId);
    }

    public void updateResourceOwnerOAuthContext(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        Lock resourceOwnerContextLock = resourceOwnerOAuthContext.getRefreshUserOAuthContextLock();
        resourceOwnerContextLock.lock();
        try {
            this.oauthContextStore.put((Serializable)((Object)resourceOwnerOAuthContext.getResourceOwnerId()), (Serializable)resourceOwnerOAuthContext);
        }
        finally {
            resourceOwnerContextLock.unlock();
        }
    }

    public void clearContextForResourceOwner(String resourceOwnerId) {
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = this.getContextForResourceOwner(resourceOwnerId);
        if (resourceOwnerOAuthContext != null) {
            resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().lock();
            try {
                this.oauthContextStore.remove((Object)resourceOwnerId);
            }
            finally {
                resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().unlock();
            }
        }
    }
}

