/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal.authorizationcode;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.module.http.api.listener.HttpListener;
import org.mule.runtime.module.http.api.listener.HttpListenerBuilder;
import org.mule.runtime.module.oauth2.internal.DynamicFlowFactory;
import org.mule.runtime.module.oauth2.internal.StateEncoder;
import org.mule.runtime.module.oauth2.internal.authorizationcode.AuthorizationCodeGrantType;
import org.mule.runtime.module.oauth2.internal.authorizationcode.AuthorizationRequestUrlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationRequestHandler
implements MuleContextAware {
    public static final String REDIRECT_STATUS_CODE = "302";
    public static final String OAUTH_STATE_ID_FLOW_VAR_NAME = "resourceOwnerId";
    private Logger logger = LoggerFactory.getLogger(AuthorizationRequestHandler.class);
    private String scopes;
    private String state;
    private String localAuthorizationUrl;
    private String authorizationUrl;
    private Map<String, String> customParameters = new HashMap<String, String>();
    private HttpListener listener;
    private MuleContext muleContext;
    private AuthorizationCodeGrantType oauthConfig;
    private AttributeEvaluator stateEvaluator;

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setLocalAuthorizationUrl(String localAuthorizationUrl) {
        this.localAuthorizationUrl = localAuthorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public void init() throws MuleException {
        try {
            this.stateEvaluator = new AttributeEvaluator(this.state).initialize(this.muleContext.getExpressionManager());
            HttpListenerBuilder httpListenerBuilder = new HttpListenerBuilder(this.muleContext);
            String flowName = "authorization-request-handler-" + this.localAuthorizationUrl;
            Flow flow = DynamicFlowFactory.createDynamicFlow(this.muleContext, flowName, this.createLocalAuthorizationUrlListener());
            httpListenerBuilder.setUrl(new URL(this.localAuthorizationUrl)).setSuccessStatusCode(REDIRECT_STATUS_CODE).setFlow(flow);
            if (this.oauthConfig.getTlsContext() != null) {
                httpListenerBuilder.setTlsContextFactory(this.oauthConfig.getTlsContext());
            }
            this.listener = httpListenerBuilder.build();
            this.listener.initialise();
            this.listener.start();
        }
        catch (MalformedURLException e) {
            this.logger.warn("Could not parse provided url %s. Validate that the url is correct", (Object)this.localAuthorizationUrl);
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private List<Processor> createLocalAuthorizationUrlListener() {
        Processor listenerMessageProcessor = muleEvent -> {
            Event.Builder builder = Event.builder((Event)muleEvent);
            String onCompleteRedirectToValue = (String)((Map)((Object)muleEvent.getMessage().getInboundProperty("http.query.params"))).get("onCompleteRedirectTo");
            String resourceOwnerId = this.getOauthConfig().getLocalAuthorizationUrlResourceOwnerIdEvaluator().resolveStringValue(muleEvent);
            muleEvent = builder.addVariable(OAUTH_STATE_ID_FLOW_VAR_NAME, (Object)resourceOwnerId).build();
            String stateValue = this.stateEvaluator.resolveStringValue(muleEvent);
            StateEncoder stateEncoder = new StateEncoder(stateValue);
            if (resourceOwnerId != null) {
                stateEncoder.encodeResourceOwnerIdInState(resourceOwnerId);
            }
            if (onCompleteRedirectToValue != null) {
                stateEncoder.encodeOnCompleteRedirectToInState(onCompleteRedirectToValue);
            }
            String authorizationUrlWithParams = new AuthorizationRequestUrlBuilder().setAuthorizationUrl(this.authorizationUrl).setClientId(this.oauthConfig.getClientId()).setClientSecret(this.oauthConfig.getClientSecret()).setCustomParameters(this.customParameters).setRedirectUrl(this.oauthConfig.getExternalCallbackUrl()).setState(stateEncoder.getEncodedState()).setScope(this.scopes).buildUrl();
            return builder.message(InternalMessage.builder((InternalMessage)muleEvent.getMessage()).addOutboundProperty("Location", (Serializable)((Object)authorizationUrlWithParams)).build()).build();
        };
        return Arrays.asList(listenerMessageProcessor);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setOauthConfig(AuthorizationCodeGrantType oauthConfig) {
        this.oauthConfig = oauthConfig;
    }

    public AuthorizationCodeGrantType getOauthConfig() {
        return this.oauthConfig;
    }
}

