/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal.authorizationcode;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.module.http.api.listener.HttpListener;
import org.mule.runtime.module.http.api.listener.HttpListenerBuilder;
import org.mule.runtime.module.oauth2.internal.AbstractTokenRequestHandler;
import org.mule.runtime.module.oauth2.internal.DynamicFlowFactory;
import org.mule.runtime.module.oauth2.internal.authorizationcode.AuthorizationCodeGrantType;
import org.mule.runtime.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizationCodeTokenRequestHandler
extends AbstractTokenRequestHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private AuthorizationCodeGrantType oauthConfig;
    private HttpListener redirectUrlListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshToken(Event currentEvent, String resourceOwnerId) throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing refresh token for user " + resourceOwnerId);
        }
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = this.getOauthConfig().getUserOAuthContext().getContextForResourceOwner(resourceOwnerId);
        boolean lockWasAcquired = resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().tryLock();
        try {
            if (lockWasAcquired) {
                this.doRefreshToken(currentEvent, resourceOwnerOAuthContext);
                this.getOauthConfig().getUserOAuthContext().updateResourceOwnerOAuthContext(resourceOwnerOAuthContext);
            }
        }
        finally {
            if (lockWasAcquired) {
                resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().unlock();
            }
        }
        if (!lockWasAcquired) {
            this.waitUntilLockGetsReleased(resourceOwnerOAuthContext);
        }
    }

    protected abstract void doRefreshToken(Event var1, ResourceOwnerOAuthContext var2) throws MuleException;

    private void waitUntilLockGetsReleased(ResourceOwnerOAuthContext resourceOwnerOAuthContext) {
        resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().lock();
        resourceOwnerOAuthContext.getRefreshUserOAuthContextLock().unlock();
    }

    public void setOauthConfig(AuthorizationCodeGrantType oauthConfig) {
        this.setTlsContextFactory(oauthConfig.getTlsContext());
        this.oauthConfig = oauthConfig;
    }

    public AuthorizationCodeGrantType getOauthConfig() {
        return this.oauthConfig;
    }

    public void init() throws MuleException {
    }

    protected void createListenerForCallbackUrl() throws MuleException {
        String flowName = "OAuthCallbackUrlFlow";
        HttpListenerBuilder httpListenerBuilder = new HttpListenerBuilder(this.getMuleContext());
        if (this.getOauthConfig().getLocalCallbackUrl() != null) {
            flowName = flowName + this.getOauthConfig().getLocalCallbackUrl();
            try {
                httpListenerBuilder.setUrl(new URL(this.getOauthConfig().getLocalCallbackUrl()));
            }
            catch (MalformedURLException e) {
                this.logger.warn("Could not parse provided url %s. Validate that the url is correct", (Object)this.getOauthConfig().getLocalCallbackUrl());
                throw new DefaultMuleException((Throwable)e);
            }
        } else if (this.getOauthConfig().getLocalCallbackConfig() != null) {
            flowName = flowName + this.getOauthConfig().getLocalCallbackConfig().getName() + "_" + this.getOauthConfig().getLocalCallbackConfigPath();
            httpListenerBuilder.setListenerConfig(this.getOauthConfig().getLocalCallbackConfig()).setPath(this.getOauthConfig().getLocalCallbackConfigPath());
        }
        Flow redirectUrlFlow = DynamicFlowFactory.createDynamicFlow(this.getMuleContext(), flowName, Arrays.asList(this.createRedirectUrlProcessor()));
        httpListenerBuilder.setFlow(redirectUrlFlow);
        if (this.getOauthConfig().getTlsContext() != null) {
            httpListenerBuilder.setTlsContextFactory(this.getOauthConfig().getTlsContext());
        }
        this.redirectUrlListener = httpListenerBuilder.build();
        this.redirectUrlListener.initialise();
        this.redirectUrlListener.start();
    }

    protected abstract Processor createRedirectUrlProcessor();
}

