/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.client.OperationOptions;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.api.client.HttpRequestOptions;
import org.mule.runtime.module.http.api.client.HttpRequestOptionsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokenRequestHandler
implements MuleContextAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext muleContext;
    private String refreshTokenWhen = "#[message.inboundProperties['http.status'] == 401 || message.inboundProperties['http.status'] == 403]";
    private String tokenUrl;
    private HttpRequestOptions httpRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().build();
    private TlsContextFactory tlsContextFactory;

    public void setRefreshTokenWhen(String refreshTokenWhen) {
        this.refreshTokenWhen = refreshTokenWhen;
    }

    public String getRefreshTokenWhen() {
        return this.refreshTokenWhen;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setTlsContextFactory(TlsContextFactory tlsContextFactory) {
        this.httpRequestOptions = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().tlsContextFactory(tlsContextFactory).build();
    }

    protected Event invokeTokenUrl(Event event) throws MuleException, TokenUrlResponseException {
        InternalMessage message = (InternalMessage)this.muleContext.getClient().send(this.tokenUrl, event.getMessage(), (OperationOptions)this.httpRequestOptions).getRight();
        Event response = Event.builder((Event)event).message(message).build();
        if ((Integer)message.getInboundProperty("http.status") >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
            throw new TokenUrlResponseException(response);
        }
        return response;
    }

    protected String getTokenUrl() {
        return this.tokenUrl;
    }

    protected class TokenUrlResponseException
    extends Exception {
        private Event tokenUrlResponse;

        public TokenUrlResponseException(Event tokenUrlResponse) {
            this.tokenUrlResponse = tokenUrlResponse;
        }

        public Event getTokenUrlResponse() {
            return this.tokenUrlResponse;
        }
    }
}

