/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.clientcredentials;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.commons.codec.binary.Base64;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.construct.Flow;
import org.mule.module.oauth2.internal.AbstractTokenRequestHandler;
import org.mule.module.oauth2.internal.ApplicationCredentials;
import org.mule.module.oauth2.internal.MuleEventLogger;
import org.mule.module.oauth2.internal.OAuthTokenMuleException;
import org.mule.module.oauth2.internal.TokenNotFoundException;
import org.mule.module.oauth2.internal.TokenResponseProcessor;
import org.mule.module.oauth2.internal.authorizationcode.TokenResponseConfiguration;
import org.mule.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.mule.module.oauth2.internal.clientcredentials.ClientCredentialsGrantType;
import org.mule.module.oauth2.internal.tokenmanager.TokenManagerConfig;
import org.mule.transport.NullPayload;

public class ClientCredentialsTokenRequestHandler
extends AbstractTokenRequestHandler
implements Initialisable,
Disposable {
    private String scopes;
    private ApplicationCredentials applicationCredentials;
    private TokenResponseConfiguration tokenResponseConfiguration = new TokenResponseConfiguration();
    private TokenManagerConfig tokenManager;
    private boolean encodeClientCredentialsInBody = false;
    private Lock refreshLock;
    private MuleEventLogger muleEventLogger = new MuleEventLogger(this.logger);

    public void setApplicationCredentials(ApplicationCredentials applicationCredentials) {
        this.applicationCredentials = applicationCredentials;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setTokenResponseConfiguration(TokenResponseConfiguration tokenResponseConfiguration) {
        this.tokenResponseConfiguration = tokenResponseConfiguration;
    }

    private void setMapPayloadWithTokenRequestParameters(MuleEvent event) throws MuleException {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        String clientId = this.applicationCredentials.getClientId();
        String clientSecret = this.applicationCredentials.getClientSecret();
        if (this.encodeClientCredentialsInBody) {
            formData.put("client_id", clientId);
            formData.put("client_secret", clientSecret);
        } else {
            String encodedCredentials = Base64.encodeBase64String((byte[])String.format("%s:%s", clientId, clientSecret).getBytes());
            event.getMessage().setOutboundProperty("Authorization", (Object)("Basic " + encodedCredentials));
        }
        if (this.scopes != null) {
            formData.put("scope", this.scopes);
        }
        event.getMessage().setPayload(formData);
    }

    public void refreshAccessToken() throws MuleException {
        boolean lockWasAcquired = this.refreshLock.tryLock();
        try {
            if (lockWasAcquired) {
                this.doRefreshAccessToken();
            }
        }
        finally {
            if (lockWasAcquired) {
                this.refreshLock.unlock();
            }
        }
        if (!lockWasAcquired) {
            this.waitUntilLockGetsReleased();
        }
    }

    private void waitUntilLockGetsReleased() {
        this.refreshLock.lock();
        this.refreshLock.unlock();
    }

    public void doRefreshAccessToken() throws MuleException {
        try {
            DefaultMuleEvent accessTokenEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)NullPayload.getInstance(), this.getMuleContext()), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)new Flow("test", this.getMuleContext()));
            this.setMapPayloadWithTokenRequestParameters((MuleEvent)accessTokenEvent);
            MuleEvent response = this.invokeTokenUrl((MuleEvent)accessTokenEvent);
            TokenResponseProcessor tokenResponseProcessor = TokenResponseProcessor.createClientCredentialsProcessor(this.tokenResponseConfiguration, this.getMuleContext().getExpressionManager());
            tokenResponseProcessor.process(response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponseProcessor.getAccessToken(), tokenResponseProcessor.getRefreshToken(), tokenResponseProcessor.getExpiresIn()});
            }
            if (!this.tokenResponseContentIsValid(tokenResponseProcessor)) {
                throw new TokenNotFoundException(response, tokenResponseProcessor);
            }
            ResourceOwnerOAuthContext defaultUserState = this.tokenManager.getConfigOAuthContext().getContextForResourceOwner("default");
            defaultUserState.setAccessToken(tokenResponseProcessor.getAccessToken());
            defaultUserState.setExpiresIn(tokenResponseProcessor.getExpiresIn());
            Map<String, Object> customResponseParameters = tokenResponseProcessor.getCustomResponseParameters();
            for (String paramName : customResponseParameters.keySet()) {
                defaultUserState.getTokenResponseParameters().put(paramName, customResponseParameters.get(paramName));
            }
            this.tokenManager.getConfigOAuthContext().updateResourceOwnerOAuthContext(defaultUserState);
        }
        catch (TokenNotFoundException e) {
            this.logger.error(String.format("Could not extract access token or refresh token from token URL. Access token is %s, Refresh token is %s", e.getTokenResponseProcessor().getAccessToken(), e.getTokenResponseProcessor().getRefreshToken()));
            this.muleEventLogger.logContent(e.getTokenUrlResponse());
            throw new OAuthTokenMuleException(e);
        }
        catch (AbstractTokenRequestHandler.TokenUrlResponseException e) {
            this.logger.error(String.format("HTTP response from token URL %s returned a failure status code", this.getTokenUrl()));
            this.muleEventLogger.logContent(e.getTokenUrlResponse());
            throw new OAuthTokenMuleException(e);
        }
    }

    private boolean tokenResponseContentIsValid(TokenResponseProcessor tokenResponseProcessor) {
        return tokenResponseProcessor.getAccessToken() != null;
    }

    public void setTokenManager(TokenManagerConfig tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setEncodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        this.encodeClientCredentialsInBody = encodeClientCredentialsInBody;
    }

    public void initialise() throws InitialisationException {
        this.refreshLock = this.getMuleContext().getLockFactory().createLock(ClientCredentialsGrantType.class.getSimpleName() + "#refreshAccessToken_" + this.hashCode());
    }
}

