/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.clientcredentials;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.module.oauth2.api.RequestAuthenticationException;
import org.mule.module.oauth2.internal.AbstractGrantType;
import org.mule.module.oauth2.internal.clientcredentials.ClientCredentialsTokenRequestHandler;
import org.mule.module.oauth2.internal.tokenmanager.TokenManagerConfig;
import org.mule.transport.ssl.api.TlsContextFactory;

public class ClientCredentialsGrantType
extends AbstractGrantType
implements Initialisable,
Startable,
MuleContextAware {
    private String clientId;
    private String clientSecret;
    private ClientCredentialsTokenRequestHandler tokenRequestHandler;
    private MuleContext muleContext;
    private TokenManagerConfig tokenManager;
    private TlsContextFactory tlsContextFactory;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setTokenRequestHandler(ClientCredentialsTokenRequestHandler tokenRequestHandler) {
        this.tokenRequestHandler = tokenRequestHandler;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }

    public void start() throws MuleException {
        this.tokenRequestHandler.refreshAccessToken();
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void initialise() throws InitialisationException {
        if (this.tokenManager == null) {
            this.tokenManager = TokenManagerConfig.createDefault(this.muleContext);
        }
        this.tokenRequestHandler.setApplicationCredentials(this);
        this.tokenRequestHandler.setTokenManager(this.tokenManager);
        if (this.tlsContextFactory != null) {
            this.tokenRequestHandler.setTlsContextFactory(this.tlsContextFactory);
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getRefreshTokenWhen() {
        return this.tokenRequestHandler.getRefreshTokenWhen();
    }

    public void refreshAccessToken() throws MuleException {
        this.tokenRequestHandler.refreshAccessToken();
    }

    public void authenticate(MuleEvent muleEvent, HttpRequestBuilder builder) throws MuleException {
        String accessToken = this.tokenManager.getConfigOAuthContext().getContextForResourceOwner("default").getAccessToken();
        if (accessToken == null) {
            throw new RequestAuthenticationException(MessageFactory.createStaticMessage((String)String.format("No access token found. Verify that you have authenticated before trying to execute an operation to the API.", new Object[0])));
        }
        builder.addHeader("Authorization", ClientCredentialsGrantType.buildAuthorizationHeaderContent(accessToken));
    }

    public boolean shouldRetry(MuleEvent firstAttemptResponseEvent) {
        Object value = this.muleContext.getExpressionManager().evaluate(this.getRefreshTokenWhen(), firstAttemptResponseEvent);
        if (!(value instanceof Boolean)) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Expression %s should return a boolean but return %s", (Object[])new Object[]{this.getRefreshTokenWhen(), value}));
        }
        Boolean shouldRetryRequest = (Boolean)value;
        if (shouldRetryRequest.booleanValue()) {
            try {
                this.refreshAccessToken();
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return shouldRetryRequest;
    }

    public void setTokenManager(TokenManagerConfig tokenManager) {
        this.tokenManager = tokenManager;
    }
}

