/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.authorizationcode;

import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.module.oauth2.api.RequestAuthenticationException;
import org.mule.module.oauth2.internal.AbstractGrantType;
import org.mule.module.oauth2.internal.authorizationcode.AbstractAuthorizationCodeTokenRequestHandler;
import org.mule.module.oauth2.internal.authorizationcode.AuthorizationCodeGrantType;
import org.mule.module.oauth2.internal.authorizationcode.AuthorizationRequestHandler;
import org.mule.module.oauth2.internal.authorizationcode.state.ConfigOAuthContext;
import org.mule.module.oauth2.internal.tokenmanager.TokenManagerConfig;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.util.AttributeEvaluator;

public class DefaultAuthorizationCodeGrantType
extends AbstractGrantType
implements Initialisable,
AuthorizationCodeGrantType,
Startable,
MuleContextAware {
    public static final String EXTERNAL_REDIRECT_URL_PROPERTY = "mule.oauth2.externalRedirectUrl";
    private String clientId;
    private String clientSecret;
    private String redirectionUrl;
    private String externalRedirectionUrl;
    private AuthorizationRequestHandler authorizationRequestHandler;
    private AbstractAuthorizationCodeTokenRequestHandler tokenRequestHandler;
    private MuleContext muleContext;
    private TlsContextFactory tlsContextFactory;
    private TokenManagerConfig tokenManagerConfig;
    private AttributeEvaluator localAuthorizationUrlResourceOwnerIdEvaluator;
    private AttributeEvaluator resourceOwnerIdEvaluator;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setRedirectionUrl(String redirectionUrl) {
        this.redirectionUrl = redirectionUrl;
    }

    public void setExternalRedirectionUrl(String externalRedirectionUrl) {
        this.externalRedirectionUrl = externalRedirectionUrl;
    }

    public void setAuthorizationRequestHandler(AuthorizationRequestHandler authorizationRequestHandler) {
        this.authorizationRequestHandler = authorizationRequestHandler;
    }

    public void setTokenRequestHandler(AbstractAuthorizationCodeTokenRequestHandler tokenRequestHandler) {
        this.tokenRequestHandler = tokenRequestHandler;
    }

    public ConfigOAuthContext getConfigOAuthContext() {
        return this.tokenManagerConfig.getConfigOAuthContext();
    }

    @Override
    public String getRedirectionUrl() {
        return this.redirectionUrl;
    }

    @Override
    public String getExternalRedirectionUrl() {
        return this.externalRedirectionUrl;
    }

    @Override
    public String getRefreshTokenWhen() {
        return this.tokenRequestHandler.getRefreshTokenWhen();
    }

    @Override
    public AttributeEvaluator getLocalAuthorizationUrlResourceOwnerIdEvaluator() {
        return this.localAuthorizationUrlResourceOwnerIdEvaluator;
    }

    @Override
    public AttributeEvaluator getResourceOwnerIdEvaluator() {
        return this.resourceOwnerIdEvaluator;
    }

    @Override
    public void refreshToken(MuleEvent currentFlowEvent, String resourceOwnerId) throws MuleException {
        this.tokenRequestHandler.refreshToken(currentFlowEvent, resourceOwnerId);
    }

    @Override
    public ConfigOAuthContext getUserOAuthContext() {
        return this.tokenManagerConfig.getConfigOAuthContext();
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }

    public void initialise() throws InitialisationException {
        try {
            if (this.tokenManagerConfig == null) {
                this.tokenManagerConfig = TokenManagerConfig.createDefault(this.muleContext);
                this.tokenManagerConfig.initialise();
            }
            if (this.localAuthorizationUrlResourceOwnerIdEvaluator == null) {
                this.localAuthorizationUrlResourceOwnerIdEvaluator = new AttributeEvaluator(null);
            }
            this.localAuthorizationUrlResourceOwnerIdEvaluator.initialize(this.muleContext.getExpressionManager());
            if (this.resourceOwnerIdEvaluator == null) {
                this.resourceOwnerIdEvaluator = new AttributeEvaluator("default");
            }
            this.resourceOwnerIdEvaluator.initialize(this.muleContext.getExpressionManager());
            String externalRedirectionUrlSystemProperty = System.getProperty(EXTERNAL_REDIRECT_URL_PROPERTY);
            if (this.externalRedirectionUrl != null && externalRedirectionUrlSystemProperty != null) {
                throw new IllegalArgumentException("Can't use both externalRedirectionUrl and mule.oauth2.externalRedirectUrl");
            }
            if (this.externalRedirectionUrl == null) {
                this.externalRedirectionUrl = externalRedirectionUrlSystemProperty != null ? externalRedirectionUrlSystemProperty : this.getRedirectionUrl();
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void authenticate(MuleEvent muleEvent, HttpRequestBuilder builder) throws MuleException {
        String resourceOwnerId = this.resourceOwnerIdEvaluator.resolveStringValue(muleEvent);
        if (resourceOwnerId == null) {
            throw new RequestAuthenticationException(MessageFactory.createStaticMessage((String)String.format("Evaluation of %s return an empty resourceOwnerId", this.localAuthorizationUrlResourceOwnerIdEvaluator.getRawValue())));
        }
        String accessToken = this.getUserOAuthContext().getContextForResourceOwner(resourceOwnerId).getAccessToken();
        if (accessToken == null) {
            throw new RequestAuthenticationException(MessageFactory.createStaticMessage((String)String.format("No access token for the %s user. Verify that you have authenticated the user before trying to execute an operation to the API.", resourceOwnerId)));
        }
        builder.addHeader("Authorization", DefaultAuthorizationCodeGrantType.buildAuthorizationHeaderContent(accessToken));
    }

    public boolean shouldRetry(MuleEvent firstAttemptResponseEvent) throws MuleException {
        if (!StringUtils.isBlank((String)this.getRefreshTokenWhen())) {
            Object value = this.muleContext.getExpressionManager().evaluate(this.getRefreshTokenWhen(), firstAttemptResponseEvent);
            if (!(value instanceof Boolean)) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Expression %s should return a boolean but return %s", (Object[])new Object[]{this.getRefreshTokenWhen(), value}));
            }
            Boolean shouldRetryRequest = (Boolean)value;
            if (shouldRetryRequest.booleanValue()) {
                try {
                    this.refreshToken(firstAttemptResponseEvent, this.resourceOwnerIdEvaluator.resolveStringValue(firstAttemptResponseEvent));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
            return shouldRetryRequest;
        }
        return false;
    }

    public void setLocalAuthorizationUrlResourceOwnerId(String resourceOwnerId) {
        this.localAuthorizationUrlResourceOwnerIdEvaluator = new AttributeEvaluator(resourceOwnerId);
    }

    public void setResourceOwnerId(String resourceOwnerId) {
        this.resourceOwnerIdEvaluator = new AttributeEvaluator(resourceOwnerId);
    }

    public void setTokenManager(TokenManagerConfig tokenManagerConfig) {
        this.tokenManagerConfig = tokenManagerConfig;
    }

    public void start() throws MuleException {
        if (this.authorizationRequestHandler != null) {
            this.authorizationRequestHandler.setOauthConfig(this);
            this.authorizationRequestHandler.init();
        }
        if (this.tokenRequestHandler != null) {
            this.tokenRequestHandler.setOauthConfig(this);
            this.tokenRequestHandler.init();
        }
    }
}

