/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.oauth2.internal.authorizationcode;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationRequestUrlBuilder {
    private static final String ADDED_PARAMETER_TEMPLATE = "&%s=";
    private Logger logger = LoggerFactory.getLogger(AuthorizationRequestUrlBuilder.class);
    private String authorizationUrl;
    private String redirectUrl;
    private String clientId;
    private String scope;
    private String clientSecret;
    private Map<String, String> customParameters = new HashMap<String, String>();
    private String state;

    public AuthorizationRequestUrlBuilder setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public AuthorizationRequestUrlBuilder setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public AuthorizationRequestUrlBuilder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public AuthorizationRequestUrlBuilder setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public AuthorizationRequestUrlBuilder setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public AuthorizationRequestUrlBuilder setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
        return this;
    }

    public String buildUrl() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.clientId), (String)"client cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.clientSecret), (String)"client cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.authorizationUrl), (String)"client cannot be blank");
        Preconditions.checkArgument((this.customParameters != null ? 1 : 0) != 0, (String)"client cannot be null");
        return this.buildAuthorizeUrl();
    }

    private final String buildAuthorizeUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.authorizationUrl);
        urlBuilder.append("?").append("response_type=code&").append("client_id=").append(this.clientId);
        try {
            if (StringUtils.isNotBlank((String)this.scope)) {
                urlBuilder.append(String.format(ADDED_PARAMETER_TEMPLATE, "scope")).append(URLEncoder.encode(this.scope, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.state)) {
                urlBuilder.append(String.format(ADDED_PARAMETER_TEMPLATE, "state")).append(URLEncoder.encode(this.state, "UTF-8"));
            }
            for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
                urlBuilder.append("&").append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            urlBuilder.append(String.format(ADDED_PARAMETER_TEMPLATE, "redirect_uri")).append(URLEncoder.encode(this.redirectUrl, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Authorization URL has been generated as follows: " + urlBuilder);
        }
        return urlBuilder.toString();
    }

    public AuthorizationRequestUrlBuilder setState(String state) {
        this.state = state;
        return this;
    }
}

