/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.transformers;

import com.mongodb.DBObject;
import java.lang.reflect.Method;
import java.util.Map;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.mongo.MongoCloudConnector;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class DbObjectToMapTransformer
extends AbstractTransformer
implements DiscoverableTransformer {
    private int weighting = 6;

    public DbObjectToMapTransformer() {
        this.registerSourceType(DataTypeFactory.create(DBObject.class));
        try {
            Method method = MongoCloudConnector.class.getMethod("dbObjectToMap", DBObject.class);
            DataType dataType = DataTypeFactory.createFromReturnType((Method)method);
            this.setReturnDataType(dataType);
        }
        catch (NoSuchMethodException _x) {
            throw new RuntimeException("Unable to find method dbObjectToMap");
        }
        this.setName("DbObjectToMapTransformer");
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        Map result = null;
        try {
            result = MongoCloudConnector.dbObjectToMap((DBObject)src);
        }
        catch (Exception exception) {
            throw new TransformerException(CoreMessages.transformFailed((String)src.getClass().getName(), (String)"java.util.Map"), (Transformer)this, (Throwable)exception);
        }
        return result;
    }

    public int getPriorityWeighting() {
        return this.weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }
}

