/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.mule.module.mongo.tools.BackupUtils;

public class RestoreFile
implements Comparable<RestoreFile> {
    private String collection;
    private File file;

    public RestoreFile(File file) {
        this.file = file;
        this.collection = BackupUtils.getCollectionName(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBObject> getCollectionObjects() throws IOException {
        DefaultDBDecoder bsonDecoder = new DefaultDBDecoder();
        BufferedInputStream inputStream = null;
        ArrayList<DBObject> dbObjects = new ArrayList<DBObject>();
        try {
            inputStream = new BufferedInputStream(new FileInputStream(this.file));
            while (inputStream.available() != 0) {
                BSONObject bsonObject = bsonDecoder.readObject((InputStream)inputStream);
                if (bsonObject == null) continue;
                dbObjects.add((DBObject)new BasicDBObject((Map)((BasicBSONObject)bsonObject)));
            }
            ArrayList<DBObject> arrayList = dbObjects;
            return arrayList;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public String getCollection() {
        return this.collection;
    }

    @Override
    public int compareTo(RestoreFile restoreFile) {
        return this.collection.compareTo(restoreFile.getCollection());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RestoreFile)) {
            return false;
        }
        RestoreFile that = (RestoreFile)obj;
        return this.areEqual(this.collection, that.collection) && this.areEqual(this.file, that.file);
    }

    private boolean areEqual(Object oThis, Object oThat) {
        return oThis == null ? oThat == null : oThis.equals(oThat);
    }

    public int hashCode() {
        return this.collection.hashCode();
    }
}

