/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.IOException;
import org.apache.commons.lang.Validate;

public class OplogCollection {
    private static final String MASTER_OPLOG = "$main";
    private static final String REPLICA_OPLOG = "rs";
    private static final String IS_MASTER_FIELD = "ismaster";
    private DB admin;
    private DB local;

    public OplogCollection(DB admin, DB local) {
        Validate.notNull((Object)admin);
        Validate.notNull((Object)local);
        this.admin = admin;
        this.local = local;
    }

    public DBCollection getOplogCollection() throws IOException {
        String oplogCollectionName = "oplog.";
        oplogCollectionName = oplogCollectionName + (this.isMaster() ? MASTER_OPLOG : REPLICA_OPLOG);
        return this.local.getCollection(oplogCollectionName);
    }

    private boolean isMaster() throws IOException {
        CommandResult commandResult = this.admin.command((DBObject)new BasicDBObject(IS_MASTER_FIELD, (Object)1));
        boolean isMaster = commandResult.getBoolean(IS_MASTER_FIELD, false);
        if (commandResult.containsField("hosts")) {
            return false;
        }
        if (!isMaster) {
            throw new IOException("oplog mode is only supported on master or replica set member");
        }
        return true;
    }
}

