/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.Validate;
import org.mule.module.mongo.api.MongoClient;
import org.mule.module.mongo.tools.AbstractMongoUtility;
import org.mule.module.mongo.tools.MongoRestoreDirectory;

public class MongoRestore
extends AbstractMongoUtility {
    private MongoClient mongoClient;
    private boolean drop;
    private boolean oplogReplay;
    private String database;

    public MongoRestore(MongoClient mongoClient, String database) {
        Validate.notNull((Object)mongoClient);
        this.mongoClient = mongoClient;
        this.database = database;
    }

    public void restore(String inputPath) throws IOException {
        Validate.notNull((Object)inputPath);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        MongoRestoreDirectory mongoRestoreDirectory = new MongoRestoreDirectory();
        mongoRestoreDirectory.setInputPath(inputPath);
        mongoRestoreDirectory.setMongoClient(this.mongoClient);
        mongoRestoreDirectory.setDatabase(this.database);
        mongoRestoreDirectory.setDrop(this.drop);
        mongoRestoreDirectory.setOplogReplay(this.oplogReplay);
        Future<Void> future = executor.submit(mongoRestoreDirectory);
        this.propagateException(future);
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setOplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
    }
}

