/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.mongo.tools;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.mule.module.mongo.tools.DumpWriter;

public class MongoDumpCollection
implements Callable<Void> {
    private final DBCollection collection;
    private DumpWriter dumpWriter;
    private DBObject query;
    private String name;
    private final List<Integer> options = new ArrayList<Integer>();

    public MongoDumpCollection(DBCollection collection) {
        this.collection = collection;
    }

    @Override
    public Void call() throws Exception {
        DBCursor cursor = this.query != null ? this.collection.find(this.query) : this.collection.find();
        cursor.sort((DBObject)new BasicDBObject("_id", (Object)1));
        for (Integer option : this.options) {
            cursor.addOption(option.intValue());
        }
        while (cursor.hasNext()) {
            BasicDBObject dbObject = (BasicDBObject)cursor.next();
            this.dumpWriter.writeObject(this.name != null ? this.name : this.collection.getName(), (DBObject)dbObject);
        }
        return null;
    }

    public void setDumpWriter(DumpWriter dumpWriter) {
        this.dumpWriter = dumpWriter;
    }

    public void setQuery(DBObject query) {
        this.query = query;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addOption(Integer option) {
        this.options.add(option);
    }
}

